/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.rconnector;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.common.database.DatabaseEndpointIdentifier;
import org.gcube.common.database.DatabaseProvider;
import org.gcube.common.database.endpoint.DatabaseEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.analysis.rconnector.Info;
import org.gcube.data.analysis.tabulardata.clientlibrary.plugin.AbstractPlugin;
import org.gcube.data.analysis.tabulardata.clientlibrary.proxy.HistoryManagerProxy;
import org.gcube.data.analysis.tabulardata.clientlibrary.proxy.TabularResourceManagerProxy;
import org.gcube.data.analysis.tabulardata.commons.utils.AuthorizationProvider;
import org.gcube.data.analysis.tabulardata.commons.utils.AuthorizationToken;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.TabularResource;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.GeometryType;
import org.gcube.data.analysis.tabulardata.model.metadata.common.NamesMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class InfoRetriever {
    private static final Logger log = LoggerFactory.getLogger(InfoRetriever.class);
    @Inject
    DatabaseProvider databaseProvider;

    public Info retrieve(String userName, Long tabularResourceId) {
        try {
            AuthorizationProvider.instance.set(new AuthorizationToken(userName, ScopeProvider.instance.get()));
            TabularResource tr = ((TabularResourceManagerProxy)AbstractPlugin.tabularResource().build()).getTabularResource(tabularResourceId.longValue());
            Table table = ((HistoryManagerProxy)AbstractPlugin.history().build()).getLastTable(tabularResourceId.longValue());
            Info info = new Info();
            info.setTableName(table.getName());
            StringBuilder queryOrder = new StringBuilder();
            StringBuilder fields = new StringBuilder();
            for (Column col : table.getColumnsExceptTypes(new Class[]{IdColumnType.class})) {
                fields.append(((NamesMetadata)col.getMetadata(NamesMetadata.class)).getTextWithLocale("en").getValue()).append(",");
                if (col.getDataType().getClass().equals(GeometryType.class)) {
                    queryOrder.append("ST_AsText(").append(col.getName()).append(")").append(",");
                    continue;
                }
                queryOrder.append(col.getName()).append(",");
            }
            fields.deleteCharAt(fields.lastIndexOf(","));
            queryOrder.deleteCharAt(queryOrder.lastIndexOf(","));
            info.setFields(fields.toString());
            info.setQueryColumns(queryOrder.toString());
            info.setUsername(userName);
            info.setUserTableName(tr.getName());
            info.setDatabase(this.retrievedatabaseInfo());
            log.info("retrieved info are " + info);
            return info;
        }
        catch (Exception e) {
            log.error("error retrieving info ", (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
    }

    Info.DataBaseInfo retrievedatabaseInfo() {
        DatabaseEndpointIdentifier endpointId = new DatabaseEndpointIdentifier("TabularData Database", "Data-ReadOnly");
        DatabaseEndpoint endpoint = this.databaseProvider.get(endpointId);
        Info.DataBaseInfo databaseInfo = new Info.DataBaseInfo();
        databaseInfo.setDatabaseUsername(endpoint.getCredentials().getUsername());
        databaseInfo.setDatabasePassword(endpoint.getCredentials().getPassword());
        Pattern pattern = Pattern.compile("[^/]*//([^:]*)[^/]*/(.*)");
        Matcher m = pattern.matcher(endpoint.getConnectionString());
        m.find();
        String databaseAddress = m.group(1);
        String databaseName = m.group(2);
        databaseInfo.setDatabaseAddress(databaseAddress);
        databaseInfo.setDatabaseName(databaseName);
        return databaseInfo;
    }
}

