package org.gcube.data.analysis.rconnector.client.proxy;

import static org.gcube.common.clients.exceptions.FaultDSL.again;

import java.net.URI;

import javax.ws.rs.client.WebTarget;

import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.scope.api.ScopeProvider;

public class DefaultConnectorProxy implements ConnectorProxy {

	private final ProxyDelegate<WebTarget> delegate;
	
	public DefaultConnectorProxy(ProxyDelegate<WebTarget> config){
		this.delegate = config;
	}
	
	@Override
	public URI connect(final String name, final Long trId) {
		Call<WebTarget, URI> call = new Call<WebTarget, URI>() {

			@Override
			public URI call(WebTarget endpoint) throws Exception {
				return endpoint.path("connect/").path(name).path(trId.toString())
						.queryParam("scope", ScopeProvider.instance.get()).getUri();
			}
		};
		try {
			return delegate.make(call);
		} catch (Exception e) {
			throw again(e).asServiceException();
		}
	}

}
