/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.nlphub.workspace;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import org.gcube.common.storagehub.client.dsl.FileContainer;
import org.gcube.common.storagehub.client.dsl.FolderContainer;
import org.gcube.common.storagehub.client.dsl.ItemContainer;
import org.gcube.common.storagehub.client.dsl.ListResolver;
import org.gcube.common.storagehub.client.dsl.OpenResolver;
import org.gcube.common.storagehub.client.dsl.StorageHubClient;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.items.AbstractFileItem;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.data.analysis.nlphub.legacy.NlpHubException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkspaceManager {
    private static final Logger logger = LoggerFactory.getLogger(WorkspaceManager.class);

    public String getPublicLink(String fileName) throws NlpHubException {
        List items;
        ListResolver listResolver;
        if (fileName == null || fileName.isEmpty()) {
            String error = "Error in get public link, the filename requested is invalid: Null";
            logger.error(error);
            throw new NlpHubException(error);
        }
        StorageHubClient shc = new StorageHubClient();
        FolderContainer rootContainer = shc.getWSRoot();
        try {
            listResolver = rootContainer.findByName(fileName);
        }
        catch (StorageHubException e) {
            String error = "Error retrieving SH Id for file " + fileName + " : " + e.getLocalizedMessage();
            logger.error(error, (Throwable)e);
            throw new NlpHubException(error, (Throwable)e);
        }
        try {
            items = listResolver.getItems();
        }
        catch (StorageHubException e) {
            String error = "Error retrieving SH Id for file " + fileName + " : " + e.getLocalizedMessage();
            logger.error(error, (Throwable)e);
            throw new NlpHubException(error, (Throwable)e);
        }
        if (items == null || items.isEmpty()) {
            String error = "Error file not found in workspace: " + fileName;
            logger.error(error);
            throw new NlpHubException(error);
        }
        Item item = (Item)items.get(0);
        logger.debug("Item: " + item);
        if (item != null) {
            URL url;
            logger.debug("Item Id=" + item.getId());
            try {
                url = shc.open(item.getId()).asFile().getPublicLink();
            }
            catch (StorageHubException e) {
                String error = "Error in get public link for file " + fileName + " : " + e.getLocalizedMessage();
                logger.error(error, (Throwable)e);
                throw new NlpHubException(error, (Throwable)e);
            }
            logger.debug("getPublicLink: " + url);
            return url.toString();
        }
        String error = "Error file not found in workspace: " + fileName;
        logger.error(error);
        throw new NlpHubException(error);
    }

    public void deleteFile(String fileName) throws NlpHubException {
        List items;
        ListResolver listResolver;
        if (fileName == null || fileName.isEmpty()) {
            String error = "Error in delete file, the filename requested is invalid: Null";
            logger.error(error);
            throw new NlpHubException(error);
        }
        StorageHubClient shc = new StorageHubClient();
        FolderContainer rootContainer = shc.getWSRoot();
        try {
            listResolver = rootContainer.findByName(fileName);
        }
        catch (StorageHubException e) {
            String error = "Error retrieving SH Id for file " + fileName + " : " + e.getLocalizedMessage();
            logger.error(error, (Throwable)e);
            throw new NlpHubException(error, (Throwable)e);
        }
        try {
            items = listResolver.getItems();
        }
        catch (StorageHubException e) {
            String error = "Error retrieving SH Id for file " + fileName + " : " + e.getLocalizedMessage();
            logger.error(error, (Throwable)e);
            throw new NlpHubException(error, (Throwable)e);
        }
        if (items == null || items.isEmpty()) {
            String error = "Error file not found in workspace: " + fileName;
            logger.error(error);
            throw new NlpHubException(error);
        }
        Item item = (Item)items.get(0);
        logger.debug("Item: " + item);
        if (item != null) {
            logger.debug("Item Id=" + item.getId());
            try {
                OpenResolver openResolver = shc.open(item.getId());
                ItemContainer itemContainer = openResolver.asItem();
                itemContainer.delete();
            }
            catch (StorageHubException e) {
                String error = "Error in delete operation for file " + fileName + " : " + e.getLocalizedMessage();
                logger.error(error, (Throwable)e);
                throw new NlpHubException(error, (Throwable)e);
            }
        } else {
            String error = "Error file not found in workspace: " + fileName;
            logger.error(error);
            throw new NlpHubException(error);
        }
    }

    public boolean uploadFile(byte[] in, String name, String description) throws NlpHubException {
        if (name == null || name.isEmpty()) {
            String error = "Error uploading the file, the filename is invalid: Null";
            logger.error(error);
            throw new NlpHubException(error);
        }
        StorageHubClient shc = new StorageHubClient();
        FolderContainer rootContainer = shc.getWSRoot();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(in);
        try {
            FileContainer fileContainer = rootContainer.uploadFile((InputStream)inputStream, name, description);
            logger.debug("Item uploaded: " + ((AbstractFileItem)fileContainer.get()).getId());
        }
        catch (StorageHubException e) {
            String error = "Error uploading the file " + name + " : " + e.getLocalizedMessage();
            logger.error(error, (Throwable)e);
            throw new NlpHubException(error, (Throwable)e);
        }
        return true;
    }
}

