/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.nlphub.legacy;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import org.gcube.data.analysis.nlphub.legacy.NerAnnotationData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NerAlgorithm {
    private static final Logger logger = LoggerFactory.getLogger(NerAlgorithm.class);
    private String name;
    private ArrayList<NerAnnotationData> annotationsData;

    public NerAlgorithm(String name) {
        logger.debug("NerAlgorithm: " + name);
        this.name = name;
        this.annotationsData = new ArrayList();
    }

    public void addAnnotationData(NerAnnotationData data) {
        this.annotationsData.add(data);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("algorithm", this.name);
        JsonArray data = new JsonArray();
        for (NerAnnotationData d : this.annotationsData) {
            data.add((JsonElement)d.toJson());
        }
        json.add("entities", (JsonElement)data);
        return json;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ArrayList<NerAnnotationData> getAnnotationsData() {
        return this.annotationsData;
    }

    public void setAnnotationsData(ArrayList<NerAnnotationData> annotationsData) {
        this.annotationsData = annotationsData;
    }
}

