package org.gcube.data.analysis.nlphub.workspace;

import static org.gcube.common.authorization.client.Constants.authorizationService;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;

import org.gcube.data.analysis.nlphub.legacy.NlpHubException;
import org.gcube.data.analysis.nlphub.shared.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkspaceManager {
	private static final Logger logger = LoggerFactory.getLogger(WorkspaceManager.class);

	public String getPublicLink(String fileName, String token) throws NlpHubException {
		try {
			String link = "";
			String user = authorizationService().get(token).getClientInfo().getId();
			String wsRoot = "/Home/" + user + "/Workspace/";
			String webapp = "https://workspace-repository.d4science.org/home-library-webapp";
			String uri = webapp + "/rest/GetPublicLink?absPath=" + URLEncoder.encode(wsRoot + fileName, "UTF-8")
					+ "&shortUrl=false";
			URL url = new URL(uri);

			HttpURLConnection connection = (HttpURLConnection) url.openConnection();
			connection.setRequestProperty(Constants.TOKEN_PARAMETER, token);
			connection.setDoInput(true);
			connection.setDoOutput(true);
			connection.setUseCaches(false);
			connection.setRequestMethod("GET");

			BufferedReader r = new BufferedReader(new InputStreamReader(connection.getInputStream()));

			StringBuffer response = new StringBuffer();
			String inputLine;
			while ((inputLine = r.readLine()) != null) {
				response.append(inputLine);
			}

			String xmlOut = response.toString();

			String begin = "<string>";
			String end = "</string>";
			int b = xmlOut.indexOf(begin);
			int e = xmlOut.indexOf(end);

			if (xmlOut.contains("Exception") || (e < 0) || (b < 0)) {
				String message = "Invalid link: " + URLEncoder.encode(xmlOut, "UTF-8");
				logger.error(message);
				throw new NlpHubException(message, null);
			}

			link = xmlOut.substring(b + begin.length(), e);
			return link;

		} catch (Exception e) {
			logger.error("Error in WorkspaceManager for getPublicLink: "+e.getLocalizedMessage(), e);
			throw new NlpHubException("Error in WorkspaceManager for getPublicLink: "+e.getLocalizedMessage(), e);
		}
	}

	public void deleteFile(String fileName, String token) throws NlpHubException {
		try {
			String user = authorizationService().get(token).getClientInfo().getId();
			String wsRoot = "/Home/" + user + "/Workspace/";
			String webapp = "https://workspace-repository.d4science.org/home-library-webapp";
			String uri = webapp + "/rest/Delete?absPath=" + URLEncoder.encode(wsRoot + fileName, "UTF-8");
			URL url = new URL(uri);

			// System.out.println(uri);

			HttpURLConnection connection = (HttpURLConnection) url.openConnection();
			connection.setRequestProperty(Constants.TOKEN_PARAMETER, token);
			connection.setDoInput(true);
			connection.setDoOutput(true);
			connection.setUseCaches(false);
			connection.setRequestMethod("GET");

			BufferedReader r = new BufferedReader(new InputStreamReader(connection.getInputStream()));

			StringBuffer response = new StringBuffer();
			String inputLine;
			while ((inputLine = r.readLine()) != null) {
				response.append(inputLine);
			}

			String xmlOut = response.toString();
			logger.debug("deleteFile: " + xmlOut);
		} catch (Exception e) {
			logger.error(e.getLocalizedMessage(), e);
			throw new NlpHubException(e.getLocalizedMessage(), e);
		}
	}

	public boolean uploadFile(byte[] in, String name, String description, String token) throws NlpHubException {
		OutputStream output = null;
		try {
			String user = authorizationService().get(token).getClientInfo().getId();
			String wsRoot = "/Home/" + user + "/Workspace/";
			String webapp = "https://workspace-repository.d4science.org/home-library-webapp";
			String uri = webapp + "/rest/Upload?name=" + URLEncoder.encode(name, "UTF-8") + "&description="
					+ URLEncoder.encode(description, "UTF-8") + "&parentPath=" + URLEncoder.encode(wsRoot, "UTF-8");
			URL url = new URL(uri);

			HttpURLConnection connection = (HttpURLConnection) url.openConnection();
			connection.setRequestProperty(Constants.TOKEN_PARAMETER, token);
			connection.setDoInput(true);
			connection.setDoOutput(true);
			connection.setUseCaches(false);
			connection.setRequestProperty(Constants.CONTENT_TYPE, Constants.MIME_TEXT);
			connection.setRequestMethod("POST");
			output = connection.getOutputStream();
			output.write(in);

			BufferedReader r = new BufferedReader(new InputStreamReader(connection.getInputStream()));

			StringBuffer response = new StringBuffer();
			String inputLine;
			while ((inputLine = r.readLine()) != null) {
				response.append(inputLine);
			}

			String xmlOut = response.toString();
			if (xmlOut.contains("Exception"))
				return false;
			return true;

		} catch (Exception e) {
			logger.error(e.getLocalizedMessage(), e);
			throw new NlpHubException(e.getLocalizedMessage(), e);
		} finally {
			// output stream must be closed anyway...
			if (output != null)
				try {
					output.close();
				} catch (IOException e) {
					logger.error(e.getLocalizedMessage(), e);
				}
		}
	}
}
