/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.generators;

import com.ning.http.client.Body;
import com.ning.http.client.BodyGenerator;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ByteArrayBodyGenerator
implements BodyGenerator {
    private final byte[] bytes;

    public ByteArrayBodyGenerator(byte[] bytes) {
        this.bytes = bytes;
    }

    public Body createBody() throws IOException {
        return new ByteBody();
    }

    protected final class ByteBody
    implements Body {
        private boolean eof = false;
        private int lastPosition = 0;

        protected ByteBody() {
        }

        public long getContentLength() {
            return ByteArrayBodyGenerator.this.bytes.length;
        }

        public long read(ByteBuffer byteBuffer) throws IOException {
            if (this.eof) {
                return -1L;
            }
            int remaining = ByteArrayBodyGenerator.this.bytes.length - this.lastPosition;
            if (remaining <= byteBuffer.capacity()) {
                byteBuffer.put(ByteArrayBodyGenerator.this.bytes, this.lastPosition, remaining);
                this.eof = true;
                return remaining;
            }
            byteBuffer.put(ByteArrayBodyGenerator.this.bytes, this.lastPosition, byteBuffer.capacity());
            this.lastPosition += byteBuffer.capacity();
            return byteBuffer.capacity();
        }

        public void close() throws IOException {
            this.lastPosition = 0;
            this.eof = false;
        }
    }
}

