package org.gcube.data.analysis.excel.engine.target;

import java.io.InputStream;
import java.util.List;

import org.gcube.common.storagehub.client.dsl.FileContainer;
import org.gcube.common.storagehub.client.dsl.FolderContainer;
import org.gcube.common.storagehub.client.dsl.ListResolver;
import org.gcube.common.storagehub.client.dsl.StorageHubClient;
import org.gcube.common.storagehub.model.items.FolderItem;
import org.gcube.common.storagehub.model.items.Item;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkspaceTargetManager {

	private Logger logger;

	public WorkspaceTargetManager() throws Exception {
		this.logger = LoggerFactory.getLogger(this.getClass());
	}

	public void generateFile(String folderName, String fileName, InputStream data) throws Exception {
		this.logger.debug("Generating file " + fileName);
		this.logger.debug("In folder " + folderName);
		StorageHubClient shc = new StorageHubClient();
		FolderContainer rootContainer = shc.getWSRoot();
		ListResolver listResolver = rootContainer.findByName(folderName);
		List<? extends Item> items = listResolver.getItems();
		FolderContainer folderContainer = null;
		if (items == null || items.isEmpty()) {
			logger.debug("No folder found create it");
			folderContainer = rootContainer.newFolder(folderName, "");
		} else {
			Item item = items.get(0);
			logger.debug("Folder found: " + item);
			if (item != null && item instanceof FolderItem) {
				FolderItem folderItem = (FolderItem) item;
				folderContainer = shc.open(folderItem.getId()).asFolder();
			} else {
				String error = "Error creating folder on workspace in Root folder,"
						+ " already exists a item with that name: [folderName="
						+ folderName + "]";
				logger.error(error);
				throw new Exception(error);
			}
		}

		if (folderContainer == null) {
			String error = "Error creating folder on workspace in Root folder: [folderName=" + folderName + "]";
			logger.error(error);
			throw new Exception(error);
		}

		FileContainer fileContainer = folderContainer.uploadFile(data, fileName, "table");

		logger.debug("File generated id:" + fileContainer.get().getId());
	}

}
