/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.excel.engine.target;

import java.io.InputStream;
import java.util.List;
import org.gcube.common.storagehub.client.dsl.FileContainer;
import org.gcube.common.storagehub.client.dsl.FolderContainer;
import org.gcube.common.storagehub.client.dsl.ListResolver;
import org.gcube.common.storagehub.client.dsl.StorageHubClient;
import org.gcube.common.storagehub.model.items.AbstractFileItem;
import org.gcube.common.storagehub.model.items.FolderItem;
import org.gcube.common.storagehub.model.items.Item;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkspaceTargetManager {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public void generateFile(String folderName, String fileName, InputStream data) throws Exception {
        this.logger.debug("Generating file " + fileName);
        this.logger.debug("In folder " + folderName);
        StorageHubClient shc = new StorageHubClient();
        FolderContainer rootContainer = shc.getWSRoot();
        ListResolver listResolver = rootContainer.findByName(folderName);
        List items = listResolver.getItems();
        FolderContainer folderContainer = null;
        if (items == null || items.isEmpty()) {
            this.logger.debug("No folder found create it");
            folderContainer = rootContainer.newFolder(folderName, "");
        } else {
            Item item = (Item)items.get(0);
            this.logger.debug("Folder found: " + item);
            if (item != null && item instanceof FolderItem) {
                FolderItem folderItem = (FolderItem)item;
                folderContainer = shc.open(folderItem.getId()).asFolder();
            } else {
                String error = "Error creating folder on workspace in Root folder, already exists a item with that name: [folderName=" + folderName + "]";
                this.logger.error(error);
                throw new Exception(error);
            }
        }
        if (folderContainer == null) {
            String error = "Error creating folder on workspace in Root folder: [folderName=" + folderName + "]";
            this.logger.error(error);
            throw new Exception(error);
        }
        FileContainer fileContainer = folderContainer.uploadFile(data, fileName, "table");
        this.logger.debug("File generated id:" + ((AbstractFileItem)fileContainer.get()).getId());
    }
}

