/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.excel;

import org.gcube.data.analysis.excel.Table;

public abstract class BasicTable
implements Table {
    private static final String DEFAULT_TABLE_NAME = "table1";
    private String tableName;
    private String excelName;
    private final char[] invalidCharacters = new char[]{'\\', '/', '*', '[', ']', ':', '?'};

    public BasicTable(String tableName) {
        this.tableName = tableName;
        this.excelName = this.removeInvalidCharacters(this.tableName);
        if (this.excelName.length() > 25) {
            this.excelName = this.excelName.substring(0, 25);
        }
    }

    private String removeInvalidCharacters(String originalString) {
        for (char invalidCharacter : this.invalidCharacters) {
            originalString = originalString.replace(invalidCharacter, '_');
        }
        return originalString;
    }

    public BasicTable() {
        this(DEFAULT_TABLE_NAME);
    }

    @Override
    public String getExcelTableName() {
        return this.excelName;
    }

    @Override
    public String getOriginalTableName() {
        return this.tableName;
    }
}

