package org.gcube.data.analysis.excel.metadata.format;

import java.util.ArrayList;
import java.util.List;

import org.gcube.data.analysis.excel.BasicTable;
import org.gcube.data.analysis.excel.data.DataColumn;
import org.gcube.data.analysis.excel.data.DataTable;

public class CodeList extends BasicTable implements DataTable {

	private class CodeListColumn implements DataColumn
	{
		private final String name;
		private final List<String> values;
		
		public CodeListColumn(String name, List<String> values) {
			this.name = name;
			this.values = values;
		}

		@Override
		public String getName() 
		{
			return this.name;
		}

		@Override
		public DataFormat getDataFormat() {
			return null;
		}

		@Override
		public List<String> getStringValues() {
			return this.values;
		}
		
	}
	
	private ArrayList<DataColumn> columns;
	
	public CodeList (String name)
	{
		super (name);
		this.columns = new ArrayList<>();
	}

	public void addColumn (String name, List<String> valueList)
	{
		this.columns.add(new CodeListColumn(name, valueList));
	}
	
	@Override
	public ArrayList<DataColumn> getColumns() 
	{
		return columns;
	}
	
	
	
}
