/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.excel.engine;

import java.util.ArrayList;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.gcube.data.analysis.excel.ColumnModel;
import org.gcube.data.analysis.excel.Table;
import org.gcube.data.analysis.excel.engine.BasicExcelGenerator;
import org.gcube.data.analysis.excel.metadata.MetadataTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExcelGeneratorMetadata
extends BasicExcelGenerator {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public ExcelGeneratorMetadata(MetadataTable metadataTable) {
        super(metadataTable);
    }

    @Override
    protected void generateSpecificSheets(XSSFWorkbook document, Table genericTable, XSSFSheet dsdSheet, Row dsdHeaderRow, Row referenceRow, Font headerFont) {
        this.logger.debug("Generating specific metadata sheets");
        MetadataTable metadataTable = (MetadataTable)genericTable;
        int cellColumnIndex = 0;
        ArrayList<ColumnModel> tableColumns = metadataTable.getColumns();
        for (int tableColumnIndex = 0; tableColumnIndex < tableColumns.size(); ++tableColumnIndex) {
            ColumnModel column = (ColumnModel)tableColumns.get(tableColumnIndex);
            this.logger.debug("Generating DSD column " + column.getName());
            cellColumnIndex = this.generateDSDColumn(dsdSheet, column, dsdHeaderRow, referenceRow, cellColumnIndex, headerFont);
            this.logger.debug("DSD column generated");
        }
    }
}

