/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.excel.metadata.format;

import java.util.List;
import java.util.Map;
import org.gcube.data.analysis.excel.data.DataTable;
import org.gcube.data.analysis.excel.metadata.format.CodeList;
import org.gcube.data.analysis.excel.metadata.format.DataFormat;

public class CodelistDataFormat
implements DataFormat {
    private CodeList codelist;

    public CodelistDataFormat(String reference, List<Map<String, List<String>>> codeListColumns) {
        this.codelist = this.generateCodelist(reference, codeListColumns);
    }

    private CodeList generateCodelist(String reference, List<Map<String, List<String>>> codeListColumns) {
        CodeList codelist = new CodeList(reference);
        for (Map<String, List<String>> codelistColumn : codeListColumns) {
            String columnName = codelistColumn.keySet().iterator().next();
            List<String> columnValues = codelistColumn.get(columnName);
            codelist.addColumn(columnName, columnValues);
        }
        return codelist;
    }

    @Override
    public String getReference() {
        return this.codelist.getTableName();
    }

    @Override
    public DataTable getDefinitionTable() {
        return this.codelist;
    }

    @Override
    public String getDataType() {
        return "TABLE";
    }
}

