/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.excel.engine;

import java.util.ArrayList;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.gcube.data.analysis.excel.Table;
import org.gcube.data.analysis.excel.data.DataColumn;
import org.gcube.data.analysis.excel.data.DataTable;
import org.gcube.data.analysis.excel.engine.BasicExcelGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExcelGenerator
extends BasicExcelGenerator {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public ExcelGenerator(DataTable table) {
        super(table);
    }

    @Override
    protected void generateSpecificSheets(XSSFWorkbook document, Table genericTable, XSSFSheet dsdSheet, Row dsdHeaderRow, Row referenceRow, Font headerFont) {
        this.logger.debug("Generating specific data sheets");
        XSSFSheet timeSeriesSheet = document.createSheet(genericTable.getTableName());
        XSSFRow timeSeriesHeaderRow = timeSeriesSheet.createRow(0);
        DataTable dataTable = (DataTable)genericTable;
        int cellColumnIndex = 0;
        ArrayList<DataColumn> tableColumns = dataTable.getColumns();
        for (int tableColumnIndex = 0; tableColumnIndex < tableColumns.size(); ++tableColumnIndex) {
            DataColumn column = (DataColumn)tableColumns.get(tableColumnIndex);
            this.logger.debug("Generating DSD column " + column.getName());
            cellColumnIndex = this.generateDSDColumn(dsdSheet, column, dsdHeaderRow, referenceRow, cellColumnIndex, headerFont);
            this.logger.debug("DSD column generated");
            this.logger.debug("Generating Timeseries column");
            this.generateDataColumn(timeSeriesSheet, column, (Row)timeSeriesHeaderRow, tableColumnIndex, headerFont);
            this.logger.debug("Timeseries column generated");
        }
    }

    private void generateDataColumn(XSSFSheet timeSeriesSheet, DataColumn column, Row timeSeriesHeaderRow, int tableColumnIndex, Font headerFont) {
        this.setHeaderCell(timeSeriesHeaderRow, column.getName(), tableColumnIndex, headerFont);
        this.logger.debug("Setting values for column " + tableColumnIndex + 1);
        this.setColumnValues(column.getStringValues(), tableColumnIndex, timeSeriesSheet, 1);
        this.logger.debug("Values set");
    }
}

