package org.gcube.data.analysis.excel.engine.target;


import java.io.InputStream;


import org.gcube.common.homelibrary.home.Home;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.HomeManager;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.common.homelibrary.util.WorkspaceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;



public class WorkspaceTargetManager {

	private Logger logger;
	private HomeManager homeManager;
	private Home home;
	
	public WorkspaceTargetManager() throws Exception{
		this.logger = LoggerFactory.getLogger(this.getClass());
		this.logger.debug("Loading home manager");
		this.homeManager = HomeLibrary.getHomeManagerFactory().getHomeManager();
		this.home = this.homeManager.getHome();

		this.logger.debug("Fields created");
	}
	
	public void generateFile (String folderName, String fileName, InputStream data) throws Exception
	{
		this.logger.debug("Generating file "+fileName);
		this.logger.debug("In folder "+folderName);
		Workspace ws = this.home.getWorkspace();
		
		WorkspaceFolder folder = getOrCreateFolder(folderName,ws);

		if (folder == null)
		{
			this.logger.error("Unable to create the folder");
			throw new InternalErrorException("Unable to generate new folder");
		}

		updateOrCreateFile(fileName, folder, data, ws);
		this.logger.debug("File generated");
	}
	
	private void updateOrCreateFile (String fileName,WorkspaceFolder folder, InputStream data, Workspace ws) throws Exception
	{
		this.logger.debug("Updating existing file or creating a new one");
		
		WorkspaceItem item = null;
		
		try
		{
			item = ws.find(fileName,folder.getId());
			
		} catch (Exception e)
		{
			this.logger.debug("File not found");
		}
		
		if (item != null && !item.isFolder())
		{
			this.logger.debug("File found, overwriting...");
			item.updateItem(data);
			this.logger.debug("File updated");
		}
		else if (item != null)
		{
			this.logger.debug("Found a folder with the same name");
			fileName = WorkspaceUtil.getUniqueName(fileName, folder);
			this.logger.debug("New name "+fileName);
			WorkspaceUtil.createExternalFile(folder, fileName, "table", data);			
			this.logger.debug("File created");
		}
		else
		{
			this.logger.debug("File not found, creating...");
			WorkspaceUtil.createExternalFile(folder, fileName, "table", data);
			this.logger.debug("File created");
		}

	}
	
	private WorkspaceFolder getOrCreateFolder (String folderName, Workspace ws) throws InternalErrorException, WorkspaceFolderNotFoundException
	{

		this.logger.debug("Finding or creating folder");
		String rootFolder = ws.getRoot().getId();
		WorkspaceFolder folder = null;
		
		try
		{
			WorkspaceItem item = ws.find(folderName, rootFolder);
			
			if (item != null && item.isFolder()){
				folder = (WorkspaceFolder) item;
				logger.debug("Folder found");
			}
			else if (item!=null)
			{
				logger.debug("Folder not existing but name already used");
				folderName = WorkspaceUtil.getUniqueName(folderName,ws.getRoot());
				logger.debug("New folder name  "+folderName);
			}
			
		} catch (Exception e)
		{
			logger.debug("Folder not found");
			
		}

		try
		{
			if (folder == null)
			{
				folder = ws.createFolder(folderName, "", ws.getRoot().getId());
				this.logger.debug("Folder created");
			}
			
		} catch (Exception e)
		{
			logger.error("Folder not found and not created",e);
			
		}
		
		return folder;

	}

}


