package org.gcube.data.analysis.excel.engine.target;


import java.io.InputStream;

import org.gcube.common.homelibrary.home.Home;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.HomeManager;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.util.WorkspaceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;



public class WorkspaceTargetManager {

	private Logger logger;
	private HomeManager homeManager;
	private Home home;
	
	public WorkspaceTargetManager() throws Exception{
		this.logger = LoggerFactory.getLogger(this.getClass());
		this.logger.debug("Loading home manager");
		this.homeManager = HomeLibrary.getHomeManagerFactory().getHomeManager();
		this.home = this.homeManager.getHome();

		this.logger.debug("Fields created");
	}
	
	public void generateFile (String folderName, String fileName, InputStream data) throws Exception
	{
		this.logger.debug("Generating file "+fileName);
		this.logger.debug("In folder "+folderName);
		Workspace ws = this.home.getWorkspace();
		this.logger.debug("Creating folder");
		WorkspaceFolder folder = ws.createFolder(folderName, "", ws.getRoot().getId());
		this.logger.debug("Folder created");
		WorkspaceUtil.createExternalFile(folder, fileName, "table", data);
		this.logger.debug("File generated");
	}
}
