/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analtsis.excel.engine.impl;

import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.gcube.data.analtsis.excel.engine.ExcelGenerator;
import org.gcube.data.analtsis.excel.engine.exceptions.ExcelNotSavedException;
import org.gcube.data.analtsis.excel.engine.target.WorkspaceTargetManager;
import org.gcube.data.analysis.excel.data.TableMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkspaceExcelGenerator
extends ExcelGenerator {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String token;
    private String fileName;
    private String folderName;

    public WorkspaceExcelGenerator(TableMetaData tableMetadata, String token, String fileName, String folderName) {
        super(tableMetadata);
        this.token = token;
        this.fileName = fileName;
        this.folderName = folderName;
    }

    @Override
    public void save() throws ExcelNotSavedException {
        this.logger.debug("Saving the document");
        try {
            this.logger.debug("Buffering excel data...");
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            this.document.write((OutputStream)outputStream);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
            this.logger.debug("Input stream ready");
            WorkspaceTargetManager target = new WorkspaceTargetManager(this.token);
            target.generateFile(this.folderName, this.fileName, inputStream);
            inputStream.close();
            outputStream.close();
        }
        catch (Exception e) {
            this.logger.error("Unable to save the excel file");
            throw new ExcelNotSavedException("Unable to save in the workspace");
        }
    }
}

