/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.dataminermanagercl.server.dmservice.wps;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.opengis.ows.x11.ExceptionReportDocument;
import net.opengis.ows.x11.OperationDocument;
import net.opengis.wps.x100.CapabilitiesDocument;
import net.opengis.wps.x100.ExecuteDocument;
import net.opengis.wps.x100.ExecuteResponseDocument;
import net.opengis.wps.x100.ProcessBriefType;
import net.opengis.wps.x100.ProcessDescriptionType;
import net.opengis.wps.x100.ProcessDescriptionsDocument;
import org.apache.commons.codec.binary.Base64;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.gcube.data.analysis.dataminermanagercl.server.dmservice.wps.DClientDescribeProcessRequest;
import org.n52.wps.client.ClientCapabiltiesRequest;
import org.n52.wps.client.WPSClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class SClient4WPSSession
implements Serializable {
    private static final long serialVersionUID = -1387670579312851370L;
    private static Logger logger = LoggerFactory.getLogger(SClient4WPSSession.class);
    private static final String OGC_OWS_URI = "http://www.opengeospatial.net/ows";
    private static String SUPPORTED_VERSION = "1.0.0";
    private HashMap<String, CapabilitiesDocument> loggedServices;
    private XmlOptions options = null;
    public HashMap<String, ProcessDescriptionsDocument> processDescriptions;
    private String user;
    private String password;

    public SClient4WPSSession(String user, String password) {
        logger.debug("Create SClient4WPSSession: [user=" + user + ", password=" + password + "]");
        this.user = user;
        this.password = password;
        this.options = new XmlOptions();
        this.options.setLoadStripWhitespace();
        this.options.setLoadTrimTextBuffer();
        this.loggedServices = new HashMap();
        this.processDescriptions = new HashMap();
    }

    public boolean connect(String url) throws WPSClientException {
        logger.info("CONNECT: " + url);
        logger.info("LoggedSevices: " + this.loggedServices.keySet());
        if (this.loggedServices.containsKey(url)) {
            logger.info("Service already registered: " + url);
            return false;
        }
        logger.debug("Service not registered");
        CapabilitiesDocument capsDoc = this.retrieveCapsViaGET(url);
        if (capsDoc != null) {
            logger.debug("Adding caps to logged services " + url);
            this.loggedServices.put(url, capsDoc);
            logger.debug("Logged Services key: " + this.loggedServices.keySet());
        } else {
            logger.error("CapsDoc is null!");
        }
        ProcessDescriptionsDocument processDescs = this.describeAllProcesses(url);
        if (processDescs != null && capsDoc != null) {
            logger.info("Adding processes descriptions to logged services " + url);
            this.processDescriptions.put(url, processDescs);
            logger.debug("ProcessDescriptions key: " + this.processDescriptions.keySet());
            return true;
        }
        logger.error("ProcessDescs  is null!");
        logger.warn("retrieving caps failed, caps are null");
        return false;
    }

    public boolean connectForMonitoring(String url) throws WPSClientException {
        logger.info("CONNECT");
        if (this.loggedServices.containsKey(url)) {
            logger.info("Service already registered: " + url);
            return false;
        }
        logger.warn("retrieving caps failed, caps are null");
        return false;
    }

    public void disconnect(String url) {
    }

    public List<String> getLoggedServices() {
        if (this.loggedServices != null && this.loggedServices.keySet() != null) {
            return new ArrayList<String>(this.loggedServices.keySet());
        }
        return new ArrayList<String>();
    }

    public boolean descriptionsAvailableInCache(String serverID) {
        return this.processDescriptions.containsKey(serverID);
    }

    private ProcessDescriptionsDocument getProcessDescriptionsFromCache(String wpsUrl) throws IOException {
        if (!this.descriptionsAvailableInCache(wpsUrl)) {
            try {
                this.connect(wpsUrl);
            }
            catch (WPSClientException e) {
                throw new IOException("Could not initialize WPS " + wpsUrl);
            }
        }
        return this.processDescriptions.get(wpsUrl);
    }

    public ProcessDescriptionType getProcessDescription(String serverID, String processID) throws IOException {
        ProcessDescriptionType[] processes;
        for (ProcessDescriptionType process : processes = this.getProcessDescriptionsFromCache(serverID).getProcessDescriptions().getProcessDescriptionArray()) {
            if (!process.getIdentifier().getStringValue().equals(processID)) continue;
            return process;
        }
        return null;
    }

    public ProcessDescriptionType[] getAllProcessDescriptions(String wpsUrl) throws IOException {
        return this.getProcessDescriptionsFromCache(wpsUrl).getProcessDescriptions().getProcessDescriptionArray();
    }

    public boolean serviceAlreadyRegistered(String serverID) {
        return this.loggedServices.containsKey(serverID);
    }

    public CapabilitiesDocument getWPSCaps(String url) {
        return this.loggedServices.get(url);
    }

    public ProcessDescriptionsDocument describeAllProcesses(String url) throws WPSClientException {
        CapabilitiesDocument doc = this.loggedServices.get(url);
        if (doc == null) {
            logger.warn("serviceCaps are null, perhaps server does not exist");
            return null;
        }
        ProcessBriefType[] processes = doc.getCapabilities().getProcessOfferings().getProcessArray();
        String[] processIDs = new String[processes.length];
        for (int i = 0; i < processIDs.length; ++i) {
            processIDs[i] = processes[i].getIdentifier().getStringValue();
        }
        return this.describeProcess(processIDs, url);
    }

    public ProcessDescriptionsDocument describeProcess(String[] processIDs, String serverID) throws WPSClientException {
        CapabilitiesDocument caps = this.loggedServices.get(serverID);
        OperationDocument.Operation[] operations = caps.getCapabilities().getOperationsMetadata().getOperationArray();
        String url = null;
        for (OperationDocument.Operation operation : operations) {
            if (!operation.getName().equals("DescribeProcess")) continue;
            url = operation.getDCPArray()[0].getHTTP().getGetArray()[0].getHref();
        }
        if (url == null) {
            throw new WPSClientException("Missing DescribeOperation in Capabilities");
        }
        return this.retrieveDescriptionViaGET(processIDs, url);
    }

    private Object execute(String serverID, ExecuteDocument execute, boolean rawData) throws WPSClientException {
        CapabilitiesDocument caps = this.loggedServices.get(serverID);
        OperationDocument.Operation[] operations = caps.getCapabilities().getOperationsMetadata().getOperationArray();
        String url = null;
        for (OperationDocument.Operation operation : operations) {
            if (!operation.getName().equals("Execute")) continue;
            url = operation.getDCPArray()[0].getHTTP().getPostArray()[0].getHref();
        }
        if (url == null) {
            throw new WPSClientException("Caps does not contain any information about the entry point for process execution");
        }
        execute.getExecute().setVersion(SUPPORTED_VERSION);
        return this.retrieveExecuteResponseViaPOST(url, execute, rawData);
    }

    public Object execute(String serverID, ExecuteDocument execute) throws WPSClientException {
        if (execute.getExecute().isSetResponseForm() && execute.getExecute().isSetResponseForm() && execute.getExecute().getResponseForm().isSetRawDataOutput()) {
            return this.execute(serverID, execute, true);
        }
        return this.execute(serverID, execute, false);
    }

    private CapabilitiesDocument retrieveCapsViaGET(String url) throws WPSClientException {
        logger.debug("retrieveCapsViaGET: " + url);
        ClientCapabiltiesRequest req = new ClientCapabiltiesRequest();
        url = req.getRequest(url);
        try {
            String authString = this.user + ":" + this.password;
            logger.debug("auth string: " + authString);
            byte[] authEncBytes = Base64.encodeBase64((byte[])authString.getBytes());
            String encoded = new String(authEncBytes);
            logger.debug("Base64 encoded auth string: " + encoded);
            URL urlObj = new URL(url);
            HttpURLConnection connection = (HttpURLConnection)urlObj.openConnection();
            connection.setRequestMethod("GET");
            connection.setDoOutput(true);
            connection.setRequestProperty("Authorization", "Basic " + encoded);
            InputStream is = connection.getInputStream();
            Document doc = this.checkInputStream(is);
            CapabilitiesDocument capabilitiesDocument = CapabilitiesDocument.Factory.parse((Node)doc, (XmlOptions)this.options);
            return capabilitiesDocument;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            throw new WPSClientException("Capabilities URL seems to be unvalid: " + url, (Exception)e);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new WPSClientException("Error occured while retrieving capabilities from url: " + url, (Exception)e);
        }
        catch (XmlException e) {
            e.printStackTrace();
            throw new WPSClientException("Error occured while parsing XML", (Exception)((Object)e));
        }
    }

    private ProcessDescriptionsDocument retrieveDescriptionViaGET(String[] processIDs, String url) throws WPSClientException {
        try {
            logger.debug("RetrieveDescription GET: " + processIDs + " url:" + url);
            Path tempFile = Files.createTempFile("WPSProcessDescriptions", "txt", new FileAttribute[0]);
            List<String> lines = new ArrayList<String>();
            lines.add("<wps:ProcessDescriptions xmlns:wps=\"http://www.opengis.net/wps/1.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xsi:schemaLocation=\"http://www.opengis.net/wps/1.0.0 http://schemas.opengis.net/wps/1.0.0/wpsDescribeProcess_response.xsd\" xml:lang=\"en-US\" service=\"WPS\" version=\"1.0.0\">");
            Files.write(tempFile, lines, Charset.defaultCharset(), StandardOpenOption.APPEND);
            for (String processId : processIDs) {
                String[] process = new String[]{processId};
                DClientDescribeProcessRequest req = new DClientDescribeProcessRequest();
                req.setIdentifier(process);
                String requestURL = req.getRequest(url);
                String authString = this.user + ":" + this.password;
                byte[] authEncBytes = Base64.encodeBase64((byte[])authString.getBytes());
                String encoded = new String(authEncBytes);
                URL urlObj = new URL(requestURL);
                HttpURLConnection connection = (HttpURLConnection)urlObj.openConnection();
                connection.setRequestMethod("GET");
                connection.setDoOutput(true);
                connection.setRequestProperty("Authorization", "Basic " + encoded);
                InputStream is = connection.getInputStream();
                lines = this.retrievesSingleDescription(is);
                Files.write(tempFile, lines, Charset.defaultCharset(), StandardOpenOption.APPEND);
            }
            lines = new ArrayList();
            lines.add("</wps:ProcessDescriptions>");
            Files.write(tempFile, lines, Charset.defaultCharset(), StandardOpenOption.APPEND);
            logger.debug(tempFile.toString());
            Document doc = null;
            try (InputStream inputStream = Files.newInputStream(tempFile, StandardOpenOption.READ);){
                doc = this.checkInputStream(inputStream);
            }
            ProcessDescriptionsDocument processDescriptionsDocument = ProcessDescriptionsDocument.Factory.parse((Node)doc, (XmlOptions)this.options);
            Files.delete(tempFile);
            return processDescriptionsDocument;
        }
        catch (MalformedURLException e) {
            logger.error("URL seems not to be valid");
            e.printStackTrace();
            throw new WPSClientException("URL seems not to be valid", (Exception)e);
        }
        catch (IOException e) {
            logger.error("Error occured while receiving data");
            e.printStackTrace();
            throw new WPSClientException("Error occured while receiving data", (Exception)e);
        }
        catch (XmlException e) {
            logger.error("Error occured while parsing ProcessDescription document");
            e.printStackTrace();
            throw new WPSClientException("Error occured while parsing ProcessDescription document", (Exception)((Object)e));
        }
        catch (Throwable e) {
            logger.error(e.getLocalizedMessage());
            e.printStackTrace();
            throw new WPSClientException(e.getLocalizedMessage(), new Exception(e));
        }
    }

    protected List<String> retrievesSingleDescription(InputStream is) throws WPSClientException {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            ArrayList<String> lines = new ArrayList<String>();
            String line = null;
            boolean elementProcessDescriptionsFound = false;
            boolean elementProcessDescriptionsClosureFound = false;
            while ((line = br.readLine()) != null) {
                int closeIndex;
                if (elementProcessDescriptionsFound) {
                    if (elementProcessDescriptionsClosureFound) {
                        if (line.contains("</wps:ProcessDescriptions>")) break;
                        lines.add(line);
                        continue;
                    }
                    closeIndex = line.indexOf(">");
                    if (closeIndex == -1) continue;
                    elementProcessDescriptionsClosureFound = true;
                    if (closeIndex != line.length() - 1) continue;
                }
                if (!line.contains("<wps:ProcessDescriptions")) continue;
                elementProcessDescriptionsFound = true;
                closeIndex = line.indexOf(">");
                if (closeIndex == -1) continue;
                elementProcessDescriptionsClosureFound = true;
                if (closeIndex != line.length() - 1) continue;
            }
            return lines;
        }
        catch (Throwable e) {
            logger.error(e.getLocalizedMessage());
            e.printStackTrace();
            throw new WPSClientException(e.getLocalizedMessage(), new Exception(e));
        }
    }

    private InputStream retrieveDataViaPOST(XmlObject obj, String urlString) throws WPSClientException {
        try {
            logger.debug("RetrieveDataViaPost(): " + urlString);
            String authString = this.user + ":" + this.password;
            logger.debug("auth string: " + authString);
            byte[] authEncBytes = Base64.encodeBase64((byte[])authString.getBytes());
            String encoded = new String(authEncBytes);
            logger.debug("Base64 encoded auth string: " + encoded);
            URL url = new URL(urlString);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Authorization", "Basic " + encoded);
            conn.setRequestProperty("Accept-Encoding", "gzip");
            conn.setRequestProperty("Content-Type", "text/xml");
            conn.setDoOutput(true);
            obj.save(conn.getOutputStream());
            InputStream input = null;
            String encoding = conn.getContentEncoding();
            input = encoding != null && encoding.equalsIgnoreCase("gzip") ? new GZIPInputStream(conn.getInputStream()) : conn.getInputStream();
            return input;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            throw new WPSClientException("URL seems to be unvalid", (Exception)e);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new WPSClientException("Error while transmission", (Exception)e);
        }
    }

    private Document checkInputStream(InputStream is) throws WPSClientException {
        try {
            DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
            fac.setNamespaceAware(true);
            Document doc = fac.newDocumentBuilder().parse(is);
            logger.debug("Document: " + doc);
            if (doc == null) {
                logger.error("Document is null");
                throw new WPSClientException("Error in check input stream: Document is null");
            }
            if (this.getFirstElementNode(doc.getFirstChild()).getLocalName().equals("ExceptionReport") && this.getFirstElementNode(doc.getFirstChild()).getNamespaceURI().equals(OGC_OWS_URI)) {
                try {
                    ExceptionReportDocument exceptionDoc = ExceptionReportDocument.Factory.parse((Node)doc);
                    logger.debug(exceptionDoc.xmlText(this.options));
                    throw new WPSClientException("Error occured while executing query", exceptionDoc);
                }
                catch (XmlException e) {
                    throw new WPSClientException("Error while parsing ExceptionReport retrieved from server", (Exception)((Object)e));
                }
            }
            logger.debug("No Exception Report");
            return doc;
        }
        catch (SAXException e) {
            logger.error("Error while parsing input: " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new WPSClientException("Error while parsing input", (Exception)e);
        }
        catch (IOException e) {
            logger.error("Error occured while transfer: " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new WPSClientException("Error occured while transfer", (Exception)e);
        }
        catch (ParserConfigurationException e) {
            logger.error("Error occured, parser is not correctly configured: " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new WPSClientException("Error occured, parser is not correctly configured", (Exception)e);
        }
        catch (WPSClientException e) {
            throw e;
        }
    }

    private Node getFirstElementNode(Node node) {
        if (node == null) {
            return null;
        }
        if (node.getNodeType() == 1) {
            return node;
        }
        return this.getFirstElementNode(node.getNextSibling());
    }

    private Object retrieveExecuteResponseViaPOST(String url, ExecuteDocument doc, boolean rawData) throws WPSClientException {
        InputStream is = this.retrieveDataViaPOST((XmlObject)doc, url);
        if (rawData) {
            return is;
        }
        Document documentObj = this.checkInputStream(is);
        ExceptionReportDocument erDoc = null;
        try {
            return ExecuteResponseDocument.Factory.parse((Node)documentObj);
        }
        catch (XmlException e) {
            try {
                erDoc = ExceptionReportDocument.Factory.parse((Node)documentObj);
            }
            catch (XmlException e1) {
                throw new WPSClientException("Error occured while parsing executeResponse", (Exception)((Object)e));
            }
            return erDoc;
        }
    }

    public String[] getProcessNames(String url) throws IOException {
        ProcessDescriptionType[] processes = this.getProcessDescriptionsFromCache(url).getProcessDescriptions().getProcessDescriptionArray();
        String[] processNames = new String[processes.length];
        for (int i = 0; i < processNames.length; ++i) {
            processNames[i] = processes[i].getIdentifier().getStringValue();
        }
        return processNames;
    }

    public Object executeViaGET(String urlString, String executeAsGETString) throws WPSClientException {
        urlString = urlString + executeAsGETString;
        logger.debug("ExecuteViaGet() Url: " + urlString);
        try {
            String authString = this.user + ":" + this.password;
            logger.debug("auth string: " + authString);
            byte[] authEncBytes = Base64.encodeBase64((byte[])authString.getBytes());
            String encoded = new String(authEncBytes);
            logger.debug("Base64 encoded auth string: " + encoded);
            URL url = new URL(urlString);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Authorization", "Basic " + encoded);
            conn.setDoOutput(true);
            InputStream is = conn.getInputStream();
            if (executeAsGETString.toUpperCase().contains("RAWDATA")) {
                logger.debug("ExecuteAsGETString as RAWDATA");
                return is;
            }
            Document doc = this.checkInputStream(is);
            ExceptionReportDocument erDoc = null;
            logger.debug("ExecuteAsGETString as Document");
            try {
                return ExecuteResponseDocument.Factory.parse((Node)doc);
            }
            catch (XmlException e) {
                e.printStackTrace();
                try {
                    erDoc = ExceptionReportDocument.Factory.parse((Node)doc);
                }
                catch (XmlException e1) {
                    e1.printStackTrace();
                    throw new WPSClientException("Error occured while parsing executeResponse", (Exception)((Object)e));
                }
                throw new WPSClientException("Error occured while parsing executeResponse", erDoc);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            throw new WPSClientException("Capabilities URL seems to be unvalid: " + urlString, (Exception)e);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new WPSClientException("Error occured while retrieving capabilities from url: " + urlString, (Exception)e);
        }
    }

    public String cancelComputation(String url, String computationId) throws WPSClientException {
        try {
            String authString = this.user + ":" + this.password;
            logger.debug("auth string: " + authString);
            byte[] authEncBytes = Base64.encodeBase64((byte[])authString.getBytes());
            String encoded = new String(authEncBytes);
            logger.debug("Base64 encoded auth string: " + encoded);
            url = url + "?id=" + computationId;
            URL urlObj = new URL(url);
            HttpURLConnection connection = (HttpURLConnection)urlObj.openConnection();
            connection.setRequestMethod("GET");
            connection.setDoOutput(true);
            connection.setRequestProperty("Authorization", "Basic " + encoded);
            String responseMessage = connection.getResponseMessage();
            return responseMessage;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            throw new WPSClientException("Capabilities URL seems to be unvalid: " + url, (Exception)e);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new WPSClientException("Error occured while retrieving capabilities from url: " + url, (Exception)e);
        }
    }
}

