/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.dataminermanagercl.server.dmservice;

import org.gcube.data.analysis.dataminermanagercl.server.dmservice.SClient4WPS;
import org.gcube.data.analysis.dataminermanagercl.server.dmservice.SClientBuilder;
import org.gcube.data.analysis.dataminermanagercl.server.util.ServiceCredentials;
import org.gcube.data.analysis.dataminermanagercl.shared.exception.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SClient4WPSBuilder
extends SClientBuilder {
    private static Logger logger = LoggerFactory.getLogger(SClient4WPSBuilder.class);
    private ServiceCredentials serviceCredendials;
    private String serviceAddressUrl;
    private boolean useUrl;

    public SClient4WPSBuilder(ServiceCredentials serviceCredentials) {
        this.serviceCredendials = serviceCredentials;
        this.useUrl = false;
    }

    public SClient4WPSBuilder(ServiceCredentials serviceCredentials, String serviceAddressUrl) {
        this.serviceCredendials = serviceCredentials;
        this.serviceAddressUrl = serviceAddressUrl;
        this.useUrl = true;
    }

    @Override
    public void buildSClient() throws ServiceException {
        try {
            SClient4WPS sClient;
            logger.debug("Build SC4WPS");
            logger.debug("ServiceCredentials: " + this.serviceCredendials);
            if (this.useUrl) {
                logger.debug("Use Url: " + this.useUrl);
                logger.debug("DataMiner Service Address: " + this.serviceAddressUrl);
                sClient = new SClient4WPS(this.serviceCredendials, this.serviceAddressUrl);
            } else {
                logger.debug("Use Url: " + this.useUrl);
                sClient = new SClient4WPS(this.serviceCredendials);
            }
            this.sClientSpec.setSClient(sClient);
        }
        catch (Throwable e) {
            logger.error(e.getLocalizedMessage());
            e.printStackTrace();
            throw new ServiceException(e.getLocalizedMessage(), e);
        }
    }
}

