/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.dataminermanagercl.shared.process;

import java.io.Serializable;

public class ComputationStatus
implements Serializable {
    private static final long serialVersionUID = -1943128398882978439L;
    private double percentage;
    private Status status;
    private String message;
    private Exception error;

    public ComputationStatus() {
        this.status = Status.ACCEPTED;
    }

    public ComputationStatus(double percentage) {
        this.percentage = percentage;
        this.status = Status.RUNNING;
    }

    public ComputationStatus(Status status, double percentage) {
        this.percentage = percentage;
        this.status = status;
    }

    public ComputationStatus(Exception error) {
        this.percentage = 100.0;
        this.status = Status.FAILED;
        this.error = error;
    }

    public boolean isComplete() {
        return this.status == Status.COMPLETE;
    }

    public boolean isFailed() {
        return this.status == Status.FAILED;
    }

    public boolean isRunning() {
        return this.status == Status.RUNNING;
    }

    public boolean isAccepted() {
        return this.status == Status.ACCEPTED;
    }

    public boolean isCancelled() {
        return this.status == Status.CANCELLED;
    }

    public boolean isPaused() {
        return false;
    }

    public boolean isTerminated() {
        return this.status == Status.COMPLETE || this.status == Status.FAILED || this.status == Status.CANCELLED;
    }

    public double getPercentage() {
        return this.percentage;
    }

    public void setPercentage(double percentage) {
        this.percentage = percentage;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Exception getError() {
        return this.error;
    }

    public void setError(Exception error) {
        this.error = error;
    }

    public String toString() {
        return "ComputationStatus [percentage=" + this.percentage + ", status=" + (Object)((Object)this.status) + ", message=" + this.message + ", error=" + this.error + "]";
    }

    public static enum Status {
        ACCEPTED,
        RUNNING,
        COMPLETE,
        FAILED,
        CANCELLED;

    }
}

