package org.gcube.data.analysis.cmemsimportercl.shared.data.tasks;

import java.io.Serializable;
import java.util.Comparator;

/**
 * 
 * @author Giancarlo Panichi
 *
 *
 */
public class ImportTaskData implements Serializable, Comparator<ImportTaskData>, Comparable<ImportTaskData> {

	private static final long serialVersionUID = 3719474205659633447L;

	private String id;

	/**
	 * The context when the task was scheduled
	 */
	private SubmissionInfoData submissionInfo;

	/**
	 * Import paramters (dataset, variables, import frequency, etc..)
	 */
	private ImportOptionsData parameters;

	/**
	 * The last execution of the task
	 */
	private ExecutionData lastExecution;

	public ImportTaskData() {
		super();
	}

	public ImportTaskData(String id, SubmissionInfoData submissionInfo, ImportOptionsData parameters,
			ExecutionData lastExecution) {
		super();
		this.id = id;
		this.submissionInfo = submissionInfo;
		this.parameters = parameters;
		this.lastExecution = lastExecution;
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public SubmissionInfoData getSubmissionInfo() {
		return submissionInfo;
	}

	public void setSubmissionInfo(SubmissionInfoData submissionInfo) {
		this.submissionInfo = submissionInfo;
	}

	public ImportOptionsData getParameters() {
		return parameters;
	}

	public void setParameters(ImportOptionsData parameters) {
		this.parameters = parameters;
	}

	public ExecutionData getLastExecution() {
		return lastExecution;
	}

	public void setLastExecution(ExecutionData lastExecution) {
		this.lastExecution = lastExecution;
	}

	@Override
	public int compare(ImportTaskData o1, ImportTaskData o2) {
		return o1.getId().compareTo(o2.getId());
	}

	@Override
	public int compareTo(ImportTaskData o) {
		return this.getId().compareTo(o.getId());
	}

	@Override
	public String toString() {
		return "ImportTaskData [id=" + id + ", submissionInfo=" + submissionInfo + ", parameters=" + parameters
				+ ", lastExecution=" + lastExecution + "]";
	}

	

}
