package org.gcube.data.analysis.cmemsimportercl.shared.data.tasks;

import java.io.Serializable;

/**
 * 
 * @author Giancarlo Panichi
 *
 *
 */
public class ExecutionReportData implements Serializable {

	private static final long serialVersionUID = -3358846228502154756L;

	/**
     * The name of the report
     */
    private String name;

    /**
     * The actual text in the report
     */
    private String text;

    /**
     * A snippet of the text
     */
    private String snippet;
    
    /**
     * The length of the report (in bytes)
     */
    private Long size;

    public ExecutionReportData(){
    	super();
    }
    
	public ExecutionReportData(String name, String text, String snippet, Long size) {
		super();
		this.name = name;
		this.text = text;
		this.snippet = snippet;
		this.size = size;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getText() {
		return text;
	}

	public void setText(String text) {
		this.text = text;
	}

	public String getSnippet() {
		return snippet;
	}

	public void setSnippet(String snippet) {
		this.snippet = snippet;
	}

	public Long getSize() {
		return size;
	}

	public void setSize(Long size) {
		this.size = size;
	}

	@Override
	public String toString() {
		return "ExecutionReportData [name=" + name + ", text=" + text + ", snippet=" + snippet + ", size=" + size + "]";
	}
    
    
    
    
}
