package org.gcube.data.analysis.cmemsimportercl.shared.data.tasks;

import java.io.Serializable;
import java.util.ArrayList;

/**
 * 
 * @author Giancarlo Panichi
 *
 *
 */
public class ExecutionData implements Serializable {

	private static final long serialVersionUID = 4744408249576598214L;

	/**
	 * The execution id.
	 */
	private String id;

	/**
	 * The start of the execution
	 */
	private String begin;

	/**
	 * The end of the execution
	 */
	private String end;

	/**
	 * When the execution was last updated.
	 */
	private String lastUpdate;

	/**
	 * The status of the execution
	 */
	private String status;

	/**
	 * The progress of the execution (between 0 and 1)
	 */
	private Double progress;

	/**
	 * 
	 */
	private ArrayList<ExecutionReportData> reports;

	public ExecutionData() {
		super();
	}

	public ExecutionData(String id, String begin, String end, String lastUpdate, String status, Double progress,
			ArrayList<ExecutionReportData> reports) {
		super();
		this.id = id;
		this.begin = begin;
		this.end = end;
		this.lastUpdate = lastUpdate;
		this.status = status;
		this.progress = progress;
		this.reports = reports;
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getBegin() {
		return begin;
	}

	public void setBegin(String begin) {
		this.begin = begin;
	}

	public String getEnd() {
		return end;
	}

	public void setEnd(String end) {
		this.end = end;
	}

	public String getLastUpdate() {
		return lastUpdate;
	}

	public void setLastUpdate(String lastUpdate) {
		this.lastUpdate = lastUpdate;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public Double getProgress() {
		return progress;
	}

	public void setProgress(Double progress) {
		this.progress = progress;
	}

	public ArrayList<ExecutionReportData> getReports() {
		return reports;
	}

	public void setReports(ArrayList<ExecutionReportData> reports) {
		this.reports = reports;
	}

	@Override
	public String toString() {
		return "ExecutionData [id=" + id + ", begin=" + begin + ", end=" + end + ", lastUpdate=" + lastUpdate
				+ ", status=" + status + ", progress=" + progress + ", reports=" + reports + "]";
	}

}
