package org.gcube.data.analysis.cmemsimportercl.shared.data.products;

import java.io.Serializable;
import java.util.Comparator;

/**
 * 
 * @author Giancarlo Panichi
 *
 */
public class DocumentData implements Comparator<DocumentData>, Comparable<DocumentData>, Serializable {

	private static final long serialVersionUID = 4380308300829511880L;
	private int id;
	private String title;
	private String url;
	private String date;

	public DocumentData() {
		super();
	}

	public DocumentData(int id, String title, String url, String date) {
		super();
		this.id = id;
		this.title = title;
		this.url = url;
		this.date = date;
	}

	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public String getDate() {
		return date;
	}

	public void setDate(String date) {
		this.date = date;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	@Override
	public int compare(DocumentData cmemsKeywordData1, DocumentData cmemsKeywordData2) {
		return cmemsKeywordData1.compareTo(cmemsKeywordData2);
	}

	@Override
	public int compareTo(DocumentData cmemsKeywordData) {
		if (this.getTitle() != null) {
			return this.getTitle().compareTo(cmemsKeywordData.getTitle());
		} else {
			return -1;
		}
	}

	@Override
	public String toString() {
		return "DocumentData [id=" + id + ", title=" + title + ", url=" + url + ", date=" + date + "]";
	}

}
