package org.gcube.data.analysis.cmemsimportercl.server.cl.command.products;

import java.util.ArrayList;
import java.util.List;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.gcube.data.analysis.cmemsimportercl.server.cl.command.CCmd;
import org.gcube.data.analysis.cmemsimportercl.server.util.ServiceSupportData;
import org.gcube.data.analysis.cmemsimportercl.shared.data.products.MotuData;
import org.gcube.data.analysis.cmemsimportercl.shared.exception.ServiceException;
import org.gcube.dataanalysis.copernicus.motu.model.MotuServer;
import org.glassfish.jersey.client.ClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 
 * @author Giancarlo Panichi
 *
 *
 */
public class CCmdCMEMSMotus implements CCmd<ArrayList<MotuData>> {
	private static final Logger logger = LoggerFactory.getLogger(CCmdCMEMSMotus.class);

	private ServiceSupportData serviceSupportData;

	public CCmdCMEMSMotus(ServiceSupportData serviceSupportData) {
		this.serviceSupportData = serviceSupportData;
		logger.debug("CCmdCMEMSMotus");
	}

	@Override
	public ArrayList<MotuData> execute() throws ServiceException {
		try {
			ClientConfig config = new ClientConfig();
			config.register(serviceSupportData.getAuthFilter());
			Client client = ClientBuilder.newClient(config);
			WebTarget service = client.target(serviceSupportData.getServiceAddress());

			// Create Request
			service=service.path("/cmems").path("motu");
			logger.debug("Request URI: "+service.getUri().toString());
			
			Response response = service.request(MediaType.APPLICATION_XML)
					.accept(MediaType.APPLICATION_XML).get();
			
			logger.debug("Response: [" + response + "]");
			
			List<MotuServer> motus = response.readEntity(new GenericType<List<MotuServer>>() {
			});

			ArrayList<MotuData> motuDataList = new ArrayList<>();

			if (motus != null && !motus.isEmpty()) {

				for (MotuServer m : motus) {

					logger.debug("Motu: [" + m.getEndpoint() + "]");
					MotuData motuData = new MotuData(m.getEndpoint());

					motuDataList.add(motuData);
				}

			}

			return motuDataList;

		} catch (Throwable e) {
			logger.error("Error in CCmdCMEMSMotus(): " + e.getLocalizedMessage(), e);
			throw new ServiceException("Error in CCmdCMEMSMotus(): " + e.getLocalizedMessage(), e);

		}
	}

}
