package org.gcube.data.analysis.cmemsimportercl.server.monitor;

import java.util.ArrayList;
import java.util.Date;
import java.util.Timer;

import org.gcube.data.analysis.cmemsimportercl.server.cl.CClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * DataManager basic Monitor
 * 
 * @author Giancarlo Panichi
 *
 *
 */
public class CMonitor {
	private static Logger logger = LoggerFactory.getLogger(CMonitor.class);
	private int sleep = 2000; // Sleep duration in millisecond
	private int delay = 2000; // Delay on first check in millisecond
	private int period = 2000;// Interval between monitoring requests in
								// millisecond
	private String taskId;
	private String executionId;
	private CClient cClient;
	private ArrayList<CMonitorListener> listeners = new ArrayList<CMonitorListener>();
	private Timer timer;
	private boolean notEnd;

	public CMonitor(String taskId, String executionId, CClient sClient) {
		logger.debug("SMonitor");
		this.taskId = taskId;
		this.executionId = executionId;
		this.cClient = sClient;

	}

	public void add(CMonitorListener listener) {
		listeners.add(listener);
	}

	public void addAll(ArrayList<CMonitorListener> listeners) {
		this.listeners.addAll(listeners);
	}

	public void start() {
		try {
			logger.debug("Start Monitoring");
			notEnd = true;
			timer = new Timer(false);
			CMonitorTask sMonitorTask = new CMonitorTask(this, taskId, executionId, cClient, listeners);
			logger.debug("Start: " + new Date());
			timer.schedule(sMonitorTask, delay, period);

			while (notEnd) {
				Thread.sleep(sleep);
			}
			logger.debug("End run");

		} catch (Throwable e) {
			logger.error(e.getLocalizedMessage());
			e.printStackTrace();

		}
	}

	public void cancel() {
		if (timer != null)
			timer.cancel();
		notEnd = false;

	}

	/**
	 * 
	 * @return Sleep duration in millisecond
	 */
	public int getSleep() {
		return sleep;
	}

	/**
	 * 
	 * @param sleep
	 *            Sleep duration in millisecond
	 */
	public void setSleep(int sleep) {
		this.sleep = sleep;
	}

	/**
	 * 
	 * @return Delay on first check in millisecond
	 */
	public int getDelay() {
		return delay;
	}

	/**
	 * 
	 * @param delay
	 *            Delay on first check in millisecond
	 */
	public void setDelay(int delay) {
		this.delay = delay;
	}

	/**
	 * 
	 * @return Interval between monitoring requests in millisecond
	 */
	public int getPeriod() {
		return period;
	}

	/**
	 * 
	 * @param period
	 *            Interval between monitoring requests in millisecond
	 */
	public void setPeriod(int period) {
		this.period = period;
	}

}
