package org.gcube.data.analysis.cmemsimportercl.server.cl;

import java.io.Serializable;
import java.util.ArrayList;

import org.gcube.data.analysis.cmemsimportercl.shared.data.products.DatasetData;
import org.gcube.data.analysis.cmemsimportercl.shared.data.products.DatasetInfoData;
import org.gcube.data.analysis.cmemsimportercl.shared.data.products.DatasetType;
import org.gcube.data.analysis.cmemsimportercl.shared.data.products.KeywordData;
import org.gcube.data.analysis.cmemsimportercl.shared.data.products.MotuData;
import org.gcube.data.analysis.cmemsimportercl.shared.data.products.ProductData;
import org.gcube.data.analysis.cmemsimportercl.shared.data.products.RegionData;
import org.gcube.data.analysis.cmemsimportercl.shared.data.products.TimeLimitsData;
import org.gcube.data.analysis.cmemsimportercl.shared.data.products.VariableData;
import org.gcube.data.analysis.cmemsimportercl.shared.data.tasks.ExecutionData;
import org.gcube.data.analysis.cmemsimportercl.shared.data.tasks.ExecutionReportData;
import org.gcube.data.analysis.cmemsimportercl.shared.data.tasks.ImportOptionsData;
import org.gcube.data.analysis.cmemsimportercl.shared.data.tasks.ImportTaskData;

/**
 * 
 * Client of service
 * 
 * @author Giancarlo Panichi
 *
 *
 */
public abstract class CClient implements Serializable {

	private static final long serialVersionUID = 7087349607933493388L;

	public CClient() {
		super();
	}

	/**
	 * 
	 * @return ArrayList of Product
	 * @throws Exception
	 *             Error
	 */
	public abstract ArrayList<ProductData> getProducts() throws Exception;

	/**
	 * 
	 * @param productId
	 *            Product Id
	 * @return ArrayList of Dataset
	 * @throws Exception
	 *             Error
	 */
	public abstract ArrayList<DatasetData> getDatasets(String productId) throws Exception;

	/**
	 * 
	 * @param productId
	 *            Product Id
	 * @param datasetType
	 *            Dataset Type
	 * @param datasetId
	 *            Dataset Id
	 * @return Dataset Info Data
	 * @throws Exception
	 *             Error
	 */
	public abstract DatasetInfoData getDatasetInfo(String productId, DatasetType datasetType, String datasetId)
			throws Exception;

	/**
	 * 
	 * @return ArrayList of Motu server
	 * @throws Exception
	 *             Error
	 */
	public abstract ArrayList<MotuData> getMotus() throws Exception;

	/**
	 * 
	 * @return ArrayList of Keywords
	 * @throws Exception
	 *             Error
	 */
	public abstract ArrayList<KeywordData> getKeywords() throws Exception;

	/**
	 * 
	 * @return ArrayList of Region
	 * @throws Exception
	 *             Error
	 */
	public abstract ArrayList<RegionData> getRegions() throws Exception;

	/**
	 * 
	 * @return ArrayList of Variable
	 * @throws Exception
	 *             Error
	 */
	public abstract ArrayList<VariableData> getVariables() throws Exception;

	/**
	 * 
	 * @return Time limits
	 * @throws Exception
	 *             Error
	 */
	public abstract TimeLimitsData getTimeLimits() throws Exception;

	//
	/**
	 * Schedule Task
	 * 
	 * 
	 * @param importOptionsData
	 *            Import Options Data
	 * @return Execution Id
	 * @throws Exception
	 *             Error
	 */
	public abstract ImportTaskData scheduleTask(ImportOptionsData importOptionsData) throws Exception;

	/**
	 * 
	 * @param importOptionsData
	 *            Import Options Data
	 * @return The dataset size preview
	 * @throws Exception
	 *             Error
	 */
	public abstract String getPreviewSize(ImportOptionsData importOptionsData) throws Exception;

	/**
	 * 
	 * @param importOptionsData
	 *            Import Options Data
	 * @return The chunk size preview
	 * @throws Exception
	 *             Error
	 */
	public abstract String getPreviewChunk(ImportOptionsData importOptionsData) throws Exception;

	// Tasks
	/**
	 * 
	 * @return ArrayList of Task
	 * @throws Exception
	 *             Error
	 */
	public abstract ArrayList<ImportTaskData> getTasks() throws Exception;

	// Executions
	/**
	 * 
	 * @param taskId
	 *            Task Id
	 * @return ArrayList of Execution Info
	 * @throws Exception
	 *             Error
	 */
	public abstract ArrayList<ExecutionData> getExecutions(String taskId) throws Exception;

	/**
	 * 
	 * @param taskId
	 *            Task Id
	 * @param executionId
	 *            Execution Id
	 * @return ArrayList of Report
	 * @throws Exception
	 *             Error
	 */
	public abstract ArrayList<ExecutionReportData> getReports(String taskId, String executionId) throws Exception;

	/**
	 * 
	 * @param taskId
	 *            Task Id
	 * @return Execution Data
	 * @throws Exception
	 *             Error
	 */
	public abstract ExecutionData executeTask(String taskId) throws Exception;

	/**
	 * 
	 * @param taskId
	 *            Task Id
	 * @param executionId
	 *            Execution Id
	 * @return Execution Info
	 * @throws Exception
	 *             Error
	 */
	public abstract ExecutionData executionInfo(String taskId, String executionId) throws Exception;

	@Override
	public String toString() {
		return "CClient";
	}

}