package org.gcube.data.analysis.cmemsimportercl.server;

import static org.gcube.common.authorization.client.Constants.authorizationService;

import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.data.analysis.cmemsimportercl.server.cl.CClient;
import org.gcube.data.analysis.cmemsimportercl.server.cl.CClient4CMEMSImporterServiceBuilder;
import org.gcube.data.analysis.cmemsimportercl.server.cl.CClientBuilder;
import org.gcube.data.analysis.cmemsimportercl.server.cl.CClientDirector;
import org.gcube.data.analysis.cmemsimportercl.server.util.ServiceCredentials;
import org.gcube.data.analysis.cmemsimportercl.shared.Constants;
import org.gcube.data.analysis.cmemsimportercl.shared.exception.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 
 * @author Giancarlo Panichi
 *
 *
 */
public class CMEMSImporterClient {

	
	private Logger logger = LoggerFactory.getLogger(CMEMSImporterClient.class);

	/**
	 * 
	 */
	public CMEMSImporterClient() {
	}

	/**
	 * 
	 * @return SClient
	 * @throws Exception
	 *             exception
	 */
	public CClient getClient() throws Exception {

		ServiceCredentials serviceCredential = getServiceCredentials();

	
		CClientBuilder sBuilder = new CClient4CMEMSImporterServiceBuilder(serviceCredential);
		CClientDirector director = new CClientDirector();
		director.setClientBuilder(sBuilder);
		director.constructClient();
		CClient sClient = director.getClient();
		logger.debug("" + sClient);
		return sClient;
	
	}

	/**
	 * 
	 * @param token
	 *            token
	 * @return SClient
	 * @throws Exception
	 *             Exception
	 */
	public CClient getClient(String token) throws Exception {

		ServiceCredentials serviceCredential = getServiceCredentials(token);

	
		CClientBuilder sBuilder = new CClient4CMEMSImporterServiceBuilder(serviceCredential);
		CClientDirector director = new CClientDirector();
		director.setClientBuilder(sBuilder);
		director.constructClient();
		CClient sClient = director.getClient();
		logger.debug("" + sClient);
		return sClient;
	
	}

	/**
	 * 
	 * @param token
	 *            token
	 * @param serviceAddressUrl
	 *            service address url
	 * @return SClient
	 * @throws Exception
	 *             exception
	 */
	public CClient getClient(String token, String serviceAddressUrl) throws Exception {

		ServiceCredentials serviceCredential = getServiceCredentials(token);

	
		CClientBuilder sBuilder = new CClient4CMEMSImporterServiceBuilder(serviceCredential, serviceAddressUrl);
		CClientDirector director = new CClientDirector();
		director.setClientBuilder(sBuilder);
		director.constructClient();
		CClient sClient = director.getClient();
		logger.debug("" + sClient);
		return sClient;
	
	}

	private ServiceCredentials getServiceCredentials() throws ServiceException {
		String userName = null;
		String token = null;
		String scope = null;

		if (Constants.DEBUG_MODE) {
			logger.debug("Debug Mode");
			userName = Constants.DEFAULT_USER;
			scope = Constants.DEFAULT_SCOPE;
			token = Constants.DEFAULT_TOKEN;
		} else {
			logger.debug("Production Mode");
			try {
				logger.debug("Retrieving token credentials");
				// get username from SmartGears
				// ClientInfo tokenInfo = (UserInfo)
				// AuthorizationProvider.instance
				// .get().getClient();
				// userName = tokenInfo.getId();
				token = SecurityTokenProvider.instance.get();
				AuthorizationEntry entry = authorizationService().get(token);
				userName = entry.getClientInfo().getId();
				scope = entry.getContext();
			} catch (Exception e) {
				logger.error("Error Retrieving token credentials: " + e.getLocalizedMessage());
				e.printStackTrace();
				throw new ServiceException(e.getLocalizedMessage(), e);
			}

		}

		ServiceCredentials serviceCredential = new ServiceCredentials(userName, scope, token);

		logger.debug("Credential: " + serviceCredential);

		return serviceCredential;

	}

	private ServiceCredentials getServiceCredentials(String token) throws ServiceException {
		String userName = null;
		String scope = null;

		if (Constants.DEBUG_MODE) {
			logger.debug("Debug Mode");
			userName = Constants.DEFAULT_USER;
			scope = Constants.DEFAULT_SCOPE;
			token = Constants.DEFAULT_TOKEN;
		} else {
			logger.debug("Production Mode");
			if (token == null || token.isEmpty()) {
				logger.error("Error Retrieving token credentials: token=" + token);
				throw new ServiceException("Error Retrieving token credentials: token=" + token);
			}

			try {
				logger.debug("Retrieving token credentials");
				AuthorizationEntry entry = authorizationService().get(token);
				userName = entry.getClientInfo().getId();
				scope = entry.getContext();
			} catch (Exception e) {
				logger.error("Error Retrieving token credentials: " + e.getLocalizedMessage());
				e.printStackTrace();
				throw new ServiceException(e.getLocalizedMessage(), e);
			}

		}

		ServiceCredentials serviceCredential = new ServiceCredentials(userName, scope, token);

		logger.debug("Credential: " + serviceCredential);

		return serviceCredential;

	}

}
