package org.gcube.data.analysis.cmemsimportercl.shared.execution;

import java.io.Serializable;

/**
 * 
 * @author Giancarlo Panichi
 *
 *
 */
public class ExecutionStatus implements Serializable {

	private static final long serialVersionUID = 13181066425456461L;

	public double progress;
	public Status status;
	public Exception error;


	public ExecutionStatus() {
		this.status = Status.RUNNING;
		this.progress = 0f;
	}

	public ExecutionStatus(double percentage) {
		super();
		this.progress = percentage;
		this.status = Status.RUNNING;
	}

	public ExecutionStatus(Status status, double percentage) {
		super();
		this.progress = percentage;
		this.status = status;
	}

	public ExecutionStatus(Exception error) {
		super();
		this.progress = 100f;
		this.status = Status.FAILED;
		this.error = error;
	}

	public boolean isComplete() {
		return this.status == Status.COMPLETE;
	}

	public boolean isFailed() {
		return this.status == Status.FAILED;
	}

	public boolean isRunning() {
		return this.status == Status.RUNNING;
	}

	public boolean isCancelled() {
		return this.status == Status.CANCELLED;
	}

	public boolean isTerminated() {
		return status == Status.COMPLETE || status == Status.FAILED || status == Status.CANCELLED;
	}

	public double getProgress() {
		return progress;
	}

	public void setProgress(double progress) {
		this.progress = progress;
	}

	public Status getStatus() {
		return status;
	}

	public void setStatus(Status status) {
		this.status = status;
	}

	public Exception getError() {
		return error;
	}

	public void setError(Exception error) {
		this.error = error;
	}

	@Override
	public String toString() {
		return "ExecutionStatus [progress=" + progress + ", status=" + status + ", error=" + error + "]";
	}



}
