package org.gcube.data.analysis.cmemsimportercl.shared.data.tasks;

import java.io.Serializable;
import java.util.ArrayList;

/**
 * 
 * @author Giancarlo Panichi
 *
 *
 */
public class ImportOptionsData implements Serializable {

	/**
	* 
	*/
	private static final long serialVersionUID = 2136408018514104818L;

	/**
	 * The name of the product.
	 */
	private String product;

	/**
	 * The name of the dataset
	 */
	private String dataset;

	/**
	 * In days
	 */
	private Integer backTime;

	/**
	 * In days
	 */
	private String importSchedule;

	/**
	 * The endpoint of the Motu server.
	 */
	private String motu;

	/**
	 * Can be day, month, year
	 */
	private String chunkSpan;

	/**
	 * Time window
	 */
	private String tLo, tHi;

	/**
	 * The variables to import
	 */
	private ArrayList<String> variables;

	/**
	 * Longitude range
	 */
	private Double xLo, xHi;

	/**
	 * Latitude range
	 */
	private Double yLo, yHi;

	/**
	 * Depth range
	 */
	private Double zLo, zHi;

	public ImportOptionsData() {
		super();
	}

	public ImportOptionsData(String product, String dataset, Integer backTime, String importSchedule, String motu,
			String chunkSpan, String tLo, String tHi, ArrayList<String> variables, Double xLo, Double xHi, Double yLo,
			Double yHi, Double zLo, Double zHi) {
		super();
		this.product = product;
		this.dataset = dataset;
		this.backTime = backTime;
		this.importSchedule = importSchedule;
		this.motu = motu;
		this.chunkSpan = chunkSpan;
		this.tLo = tLo;
		this.tHi = tHi;
		this.variables = variables;
		this.xLo = xLo;
		this.xHi = xHi;
		this.yLo = yLo;
		this.yHi = yHi;
		this.zLo = zLo;
		this.zHi = zHi;
	}

	public Integer getBackTime() {
		return backTime;
	}

	public void setBackTime(Integer backTime) {
		this.backTime = backTime;
	}

	public String getDataset() {
		return dataset;
	}

	public void setDataset(String dataset) {
		this.dataset = dataset;
	}

	public String getImportSchedule() {
		return importSchedule;
	}

	public void setImportSchedule(String importSchedule) {
		this.importSchedule = importSchedule;
	}

	public String getMotu() {
		return motu;
	}

	public void setMotu(String motu) {
		this.motu = motu;
	}

	public String getProduct() {
		return product;
	}

	public void setProduct(String product) {
		this.product = product;
	}

	public String getChunkSpan() {
		return chunkSpan;
	}

	public void setChunkSpan(String chunkSpan) {
		this.chunkSpan = chunkSpan;
	}

	public String gettLo() {
		return tLo;
	}

	public void settLo(String tLo) {
		this.tLo = tLo;
	}

	public String gettHi() {
		return tHi;
	}

	public void settHi(String tHi) {
		this.tHi = tHi;
	}

	public ArrayList<String> getVariables() {
		return variables;
	}

	public void setVariables(ArrayList<String> variables) {
		this.variables = variables;
	}

	public Double getxLo() {
		return xLo;
	}

	public void setxLo(Double xLo) {
		this.xLo = xLo;
	}

	public Double getxHi() {
		return xHi;
	}

	public void setxHi(Double xHi) {
		this.xHi = xHi;
	}

	public Double getyLo() {
		return yLo;
	}

	public void setyLo(Double yLo) {
		this.yLo = yLo;
	}

	public Double getyHi() {
		return yHi;
	}

	public void setyHi(Double yHi) {
		this.yHi = yHi;
	}

	public Double getzLo() {
		return zLo;
	}

	public void setzLo(Double zLo) {
		this.zLo = zLo;
	}

	public Double getzHi() {
		return zHi;
	}

	public void setzHi(Double zHi) {
		this.zHi = zHi;
	}

	@Override
	public String toString() {
		return "ImportOptionsData [product=" + product + ", dataset=" + dataset + ", backTime=" + backTime
				+ ", importSchedule=" + importSchedule + ", motu=" + motu + ", chunkSpan=" + chunkSpan + ", tLo=" + tLo
				+ ", tHi=" + tHi + ", variables=" + variables + ", xLo=" + xLo + ", xHi=" + xHi + ", yLo=" + yLo
				+ ", yHi=" + yHi + ", zLo=" + zLo + ", zHi=" + zHi + "]";
	}

}
