package org.gcube.data.analysis.cmemsimportercl.shared.data.tasks;

/**
 * 
 * @author Giancarlo Panichi
 *
 */
public enum ChunkSpanType {
	Year("year"), Month("month");

	private ChunkSpanType(final String id) {
		this.id = id;
	}

	private final String id;

	@Override
	public String toString() {
		return id;
	}

	public String getLabel() {
		return id;
	}

	public static ChunkSpanType getChunckSpanTypeFromId(String id) {
		for (ChunkSpanType type : values()) {
			if (type.id.compareToIgnoreCase(id) == 0) {
				return type;
			}
		}
		return null;
	}
}
