package org.gcube.data.analysis.cmemsimportercl.shared.data.products;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;

/**
 * 
 * @author Giancarlo Panichi
 *
 *
 */
public class ProductData implements Serializable, Comparator<ProductData>, Comparable<ProductData> {

	private static final long serialVersionUID = -3451466410777498956L;
	private String id;
	private String externalShortname;
	private String abztract;
	private String displayPriority;
	private String version;
	private String shortDescription;
	private String creationDate;
	private String updateDate;
	private String quicklooks;
	private String featureType;
	private String forecastLength;
	private ArrayList<KeywordData> allKeywords;
	private ArrayList<RegionData> geographicalArea;
	private String missionType;
	private String modelAssimilation;
	private ArrayList<VariableData> oceanVariables;
	private ArrayList<KeywordData> oceanKeys;
	private String processingLevel;
	private Double west;
	private Double east;
	private Double south;
	private Double north;
	private Double spatialResolutionRow;
	private String spatialResolutionRowUnit;
	private Double spatialResolutionColumn;
	private String spatialResolutionColumnUnit;
	private String coordRefSys;
	private Double verticalMin;
	private Double verticalMax;
	private String verticalCrs;
	private String verticalLevels;
	private String temporalResolution;
	private String verticalCoverage;
	private String temporalBegin;
	private String temporalEnd;
	private String temporalExtent;
	private String temporalScale;
	private String updateFrequency;
	private String updateSchedule;
	private String productionUnit;
	private String credit;
	private ArrayList<DocumentData> documentation;
	private String mail;
	private String ftp;
	private String dgf;
	private String tds;
	private String wms;
	private String serviceDesk;
	private String upstreamProduction;
	private String upstreamValidation;
	private String downstreamValidation;
	private String downstreamProduction;
	private String myoOK;
	private String versionId;

	public ProductData() {
		super();
	}

	public ProductData(String id, String externalShortname, String abztract, String displayPriority, String version,
			String shortDescription, String creationDate, String updateDate, String quicklooks, String featureType,
			String forecastLength, ArrayList<KeywordData> allKeywords, ArrayList<RegionData> geographicalArea,
			String missionType, String modelAssimilation, ArrayList<VariableData> oceanVariables,
			ArrayList<KeywordData> oceanKeys, String processingLevel, Double west, Double east, Double south,
			Double north, Double spatialResolutionRow, String spatialResolutionRowUnit, Double spatialResolutionColumn,
			String spatialResolutionColumnUnit, String coordRefSys, Double verticalMin, Double verticalMax,
			String verticalCrs, String verticalLevels, String temporalResolution, String verticalCoverage,
			String temporalBegin, String temporalEnd, String temporalExtent, String temporalScale,
			String updateFrequency, String updateSchedule, String productionUnit, String credit,
			ArrayList<DocumentData> documentation, String mail, String ftp, String dgf, String tds, String wms,
			String serviceDesk, String upstreamProduction, String upstreamValidation, String downstreamValidation,
			String downstreamProduction, String myoOK, String versionId) {
		super();
		this.id = id;
		this.externalShortname = externalShortname;
		this.abztract = abztract;
		this.displayPriority = displayPriority;
		this.version = version;
		this.shortDescription = shortDescription;
		this.creationDate = creationDate;
		this.updateDate = updateDate;
		this.quicklooks = quicklooks;
		this.featureType = featureType;
		this.forecastLength = forecastLength;
		this.allKeywords = allKeywords;
		this.geographicalArea = geographicalArea;
		this.missionType = missionType;
		this.modelAssimilation = modelAssimilation;
		this.oceanVariables = oceanVariables;
		this.oceanKeys = oceanKeys;
		this.processingLevel = processingLevel;
		this.west = west;
		this.east = east;
		this.south = south;
		this.north = north;
		this.spatialResolutionRow = spatialResolutionRow;
		this.spatialResolutionRowUnit = spatialResolutionRowUnit;
		this.spatialResolutionColumn = spatialResolutionColumn;
		this.spatialResolutionColumnUnit = spatialResolutionColumnUnit;
		this.coordRefSys = coordRefSys;
		this.verticalMin = verticalMin;
		this.verticalMax = verticalMax;
		this.verticalCrs = verticalCrs;
		this.verticalLevels = verticalLevels;
		this.temporalResolution = temporalResolution;
		this.verticalCoverage = verticalCoverage;
		this.temporalBegin = temporalBegin;
		this.temporalEnd = temporalEnd;
		this.temporalExtent = temporalExtent;
		this.temporalScale = temporalScale;
		this.updateFrequency = updateFrequency;
		this.updateSchedule = updateSchedule;
		this.productionUnit = productionUnit;
		this.credit = credit;
		this.documentation = documentation;
		this.mail = mail;
		this.ftp = ftp;
		this.dgf = dgf;
		this.tds = tds;
		this.wms = wms;
		this.serviceDesk = serviceDesk;
		this.upstreamProduction = upstreamProduction;
		this.upstreamValidation = upstreamValidation;
		this.downstreamValidation = downstreamValidation;
		this.downstreamProduction = downstreamProduction;
		this.myoOK = myoOK;
		this.versionId = versionId;
	}

	public String getAbztract() {
		return abztract;
	}

	public void setAbztract(String abztract) {
		this.abztract = abztract;
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getExternalShortname() {
		return externalShortname;
	}

	public void setExternalShortname(String externalShortname) {
		this.externalShortname = externalShortname;
	}

	public String getDisplayPriority() {
		return displayPriority;
	}

	public void setDisplayPriority(String displayPriority) {
		this.displayPriority = displayPriority;
	}

	public String getVersion() {
		return version;
	}

	public void setVersion(String version) {
		this.version = version;
	}

	public String getShortDescription() {
		return shortDescription;
	}

	public void setShortDescription(String shortDescription) {
		this.shortDescription = shortDescription;
	}

	public String getCreationDate() {
		return creationDate;
	}

	public void setCreationDate(String creationDate) {
		this.creationDate = creationDate;
	}

	public String getUpdateDate() {
		return updateDate;
	}

	public void setUpdateDate(String updateDate) {
		this.updateDate = updateDate;
	}

	public String getQuicklooks() {
		return quicklooks;
	}

	public void setQuicklooks(String quicklooks) {
		this.quicklooks = quicklooks;
	}

	public String getFeatureType() {
		return featureType;
	}

	public void setFeatureType(String featureType) {
		this.featureType = featureType;
	}

	public String getForecastLength() {
		return forecastLength;
	}

	public void setForecastLength(String forecastLength) {
		this.forecastLength = forecastLength;
	}

	public ArrayList<KeywordData> getAllKeywords() {
		return allKeywords;
	}

	public void setAllKeywords(ArrayList<KeywordData> allKeywords) {
		this.allKeywords = allKeywords;
	}

	public ArrayList<RegionData> getGeographicalArea() {
		return geographicalArea;
	}

	public void setGeographicalArea(ArrayList<RegionData> geographicalArea) {
		this.geographicalArea = geographicalArea;
	}

	public String getMissionType() {
		return missionType;
	}

	public void setMissionType(String missionType) {
		this.missionType = missionType;
	}

	public String getModelAssimilation() {
		return modelAssimilation;
	}

	public void setModelAssimilation(String modelAssimilation) {
		this.modelAssimilation = modelAssimilation;
	}

	public ArrayList<VariableData> getOceanVariables() {
		return oceanVariables;
	}

	public void setOceanVariables(ArrayList<VariableData> oceanVariables) {
		this.oceanVariables = oceanVariables;
	}

	public ArrayList<KeywordData> getOceanKeys() {
		return oceanKeys;
	}

	public void setOceanKeys(ArrayList<KeywordData> oceanKeys) {
		this.oceanKeys = oceanKeys;
	}

	public String getProcessingLevel() {
		return processingLevel;
	}

	public void setProcessingLevel(String processingLevel) {
		this.processingLevel = processingLevel;
	}

	public Double getWest() {
		return west;
	}

	public void setWest(Double west) {
		this.west = west;
	}

	public Double getEast() {
		return east;
	}

	public void setEast(Double east) {
		this.east = east;
	}

	public Double getSouth() {
		return south;
	}

	public void setSouth(Double south) {
		this.south = south;
	}

	public Double getNorth() {
		return north;
	}

	public void setNorth(Double north) {
		this.north = north;
	}

	public Double getSpatialResolutionRow() {
		return spatialResolutionRow;
	}

	public void setSpatialResolutionRow(Double spatialResolutionRow) {
		this.spatialResolutionRow = spatialResolutionRow;
	}

	public String getSpatialResolutionRowUnit() {
		return spatialResolutionRowUnit;
	}

	public void setSpatialResolutionRowUnit(String spatialResolutionRowUnit) {
		this.spatialResolutionRowUnit = spatialResolutionRowUnit;
	}

	public Double getSpatialResolutionColumn() {
		return spatialResolutionColumn;
	}

	public void setSpatialResolutionColumn(Double spatialResolutionColumn) {
		this.spatialResolutionColumn = spatialResolutionColumn;
	}

	public String getSpatialResolutionColumnUnit() {
		return spatialResolutionColumnUnit;
	}

	public void setSpatialResolutionColumnUnit(String spatialResolutionColumnUnit) {
		this.spatialResolutionColumnUnit = spatialResolutionColumnUnit;
	}

	public String getCoordRefSys() {
		return coordRefSys;
	}

	public void setCoordRefSys(String coordRefSys) {
		this.coordRefSys = coordRefSys;
	}

	public Double getVerticalMin() {
		return verticalMin;
	}

	public void setVerticalMin(Double verticalMin) {
		this.verticalMin = verticalMin;
	}

	public Double getVerticalMax() {
		return verticalMax;
	}

	public void setVerticalMax(Double verticalMax) {
		this.verticalMax = verticalMax;
	}

	public String getVerticalCrs() {
		return verticalCrs;
	}

	public void setVerticalCrs(String verticalCrs) {
		this.verticalCrs = verticalCrs;
	}

	public String getVerticalLevels() {
		return verticalLevels;
	}

	public void setVerticalLevels(String verticalLevels) {
		this.verticalLevels = verticalLevels;
	}

	public String getTemporalResolution() {
		return temporalResolution;
	}

	public void setTemporalResolution(String temporalResolution) {
		this.temporalResolution = temporalResolution;
	}

	public String getVerticalCoverage() {
		return verticalCoverage;
	}

	public void setVerticalCoverage(String verticalCoverage) {
		this.verticalCoverage = verticalCoverage;
	}

	public String getTemporalBegin() {
		return temporalBegin;
	}

	public void setTemporalBegin(String temporalBegin) {
		this.temporalBegin = temporalBegin;
	}

	public String getTemporalEnd() {
		return temporalEnd;
	}

	public void setTemporalEnd(String temporalEnd) {
		this.temporalEnd = temporalEnd;
	}

	public String getTemporalExtent() {
		return temporalExtent;
	}

	public void setTemporalExtent(String temporalExtent) {
		this.temporalExtent = temporalExtent;
	}

	public String getTemporalScale() {
		return temporalScale;
	}

	public void setTemporalScale(String temporalScale) {
		this.temporalScale = temporalScale;
	}

	public String getUpdateFrequency() {
		return updateFrequency;
	}

	public void setUpdateFrequency(String updateFrequency) {
		this.updateFrequency = updateFrequency;
	}

	public String getUpdateSchedule() {
		return updateSchedule;
	}

	public void setUpdateSchedule(String updateSchedule) {
		this.updateSchedule = updateSchedule;
	}

	public String getProductionUnit() {
		return productionUnit;
	}

	public void setProductionUnit(String productionUnit) {
		this.productionUnit = productionUnit;
	}

	public String getCredit() {
		return credit;
	}

	public void setCredit(String credit) {
		this.credit = credit;
	}

	public ArrayList<DocumentData> getDocumentation() {
		return documentation;
	}

	public void setDocumentation(ArrayList<DocumentData> documentation) {
		this.documentation = documentation;
	}

	public String getMail() {
		return mail;
	}

	public void setMail(String mail) {
		this.mail = mail;
	}

	public String getFtp() {
		return ftp;
	}

	public void setFtp(String ftp) {
		this.ftp = ftp;
	}

	public String getDgf() {
		return dgf;
	}

	public void setDgf(String dgf) {
		this.dgf = dgf;
	}

	public String getTds() {
		return tds;
	}

	public void setTds(String tds) {
		this.tds = tds;
	}

	public String getWms() {
		return wms;
	}

	public void setWms(String wms) {
		this.wms = wms;
	}

	public String getServiceDesk() {
		return serviceDesk;
	}

	public void setServiceDesk(String serviceDesk) {
		this.serviceDesk = serviceDesk;
	}

	public String getUpstreamProduction() {
		return upstreamProduction;
	}

	public void setUpstreamProduction(String upstreamProduction) {
		this.upstreamProduction = upstreamProduction;
	}

	public String getUpstreamValidation() {
		return upstreamValidation;
	}

	public void setUpstreamValidation(String upstreamValidation) {
		this.upstreamValidation = upstreamValidation;
	}

	public String getDownstreamValidation() {
		return downstreamValidation;
	}

	public void setDownstreamValidation(String downstreamValidation) {
		this.downstreamValidation = downstreamValidation;
	}

	public String getDownstreamProduction() {
		return downstreamProduction;
	}

	public void setDownstreamProduction(String downstreamProduction) {
		this.downstreamProduction = downstreamProduction;
	}

	public String getMyoOK() {
		return myoOK;
	}

	public void setMyoOK(String myoOK) {
		this.myoOK = myoOK;
	}

	public String getVersionId() {
		return versionId;
	}

	public void setVersionId(String versionId) {
		this.versionId = versionId;
	}

	@Override
	public int compare(ProductData o1, ProductData o2) {
		return o1.getId().compareTo(o2.getId());
	}

	@Override
	public int compareTo(ProductData o) {
		return this.getId().compareTo(o.getId());
	}

	@Override
	public String toString() {
		return "ProductData [id=" + id + ", externalShortname=" + externalShortname + ", abztract=" + abztract
				+ ", displayPriority=" + displayPriority + ", version=" + version + ", shortDescription="
				+ shortDescription + ", creationDate=" + creationDate + ", updateDate=" + updateDate + ", quicklooks="
				+ quicklooks + ", featureType=" + featureType + ", forecastLength=" + forecastLength + ", allKeywords="
				+ allKeywords + ", geographicalArea=" + geographicalArea + ", missionType=" + missionType
				+ ", modelAssimilation=" + modelAssimilation + ", oceanVariables=" + oceanVariables + ", oceanKeys="
				+ oceanKeys + ", processingLevel=" + processingLevel + ", west=" + west + ", east=" + east + ", south="
				+ south + ", north=" + north + ", spatialResolutionRow=" + spatialResolutionRow
				+ ", spatialResolutionRowUnit=" + spatialResolutionRowUnit + ", spatialResolutionColumn="
				+ spatialResolutionColumn + ", spatialResolutionColumnUnit=" + spatialResolutionColumnUnit
				+ ", coordRefSys=" + coordRefSys + ", verticalMin=" + verticalMin + ", verticalMax=" + verticalMax
				+ ", verticalCrs=" + verticalCrs + ", verticalLevels=" + verticalLevels + ", temporalResolution="
				+ temporalResolution + ", verticalCoverage=" + verticalCoverage + ", temporalBegin=" + temporalBegin
				+ ", temporalEnd=" + temporalEnd + ", temporalExtent=" + temporalExtent + ", temporalScale="
				+ temporalScale + ", updateFrequency=" + updateFrequency + ", updateSchedule=" + updateSchedule
				+ ", productionUnit=" + productionUnit + ", credit=" + credit + ", documentation=" + documentation
				+ ", mail=" + mail + ", ftp=" + ftp + ", dgf=" + dgf + ", tds=" + tds + ", wms=" + wms
				+ ", serviceDesk=" + serviceDesk + ", upstreamProduction=" + upstreamProduction
				+ ", upstreamValidation=" + upstreamValidation + ", downstreamValidation=" + downstreamValidation
				+ ", downstreamProduction=" + downstreamProduction + ", myoOK=" + myoOK + ", versionId=" + versionId
				+ "]";
	}

}
