package org.gcube.data.analysis.cmemsimportercl.server.cl;

import org.gcube.data.analysis.cmemsimportercl.server.util.ServiceCredentials;
import org.gcube.data.analysis.cmemsimportercl.shared.exception.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Builder of CClient 4 CMEMS Service
 * 
 * @author Giancarlo Panichi
 *
 * 
 */
public class CClient4CMEMSImporterServiceBuilder extends CClientBuilder {
	private static Logger logger = LoggerFactory.getLogger(CClient4CMEMSImporterServiceBuilder.class);
	private ServiceCredentials serviceCredendials;
	private String serviceAddressUrl;
	private boolean useUrl;

	/**
	 * 
	 * @param serviceCredentials
	 *            service credentials
	 */
	public CClient4CMEMSImporterServiceBuilder(ServiceCredentials serviceCredentials) {
		this.serviceCredendials = serviceCredentials;
		this.useUrl = false;
	}

	/**
	 * 
	 * @param serviceCredentials
	 *            service credentials
	 * @param serviceAddressUrl
	 *            valid url
	 */
	public CClient4CMEMSImporterServiceBuilder(ServiceCredentials serviceCredentials, String serviceAddressUrl) {
		this.serviceCredendials = serviceCredentials;
		this.serviceAddressUrl = serviceAddressUrl;
		this.useUrl = true;
	}

	@Override
	public void buildClient() throws ServiceException {
		try {
			logger.debug("Build C4CMEMSImporterService");
			logger.debug("ServiceCredentials: " + serviceCredendials);
			CClient client;
			if (useUrl) {
				logger.debug("Use Url: " + useUrl);
				logger.debug("CMEMS Importer Service Address: " + serviceAddressUrl);
				client = new CClient4CMEMSImporterService(serviceCredendials, serviceAddressUrl);
			} else {
				logger.debug("Use Url: " + useUrl);
				client = new CClient4CMEMSImporterService(serviceCredendials);
			}
			cClientSpec.setClient(client);
		} catch (Throwable e) {
			logger.error(e.getLocalizedMessage());
			e.printStackTrace();
			throw new ServiceException(e.getLocalizedMessage(), e);
		}
	}

}
