package org.gcube.data.analysis.cmemsimportercl.shared.execution;

/**
 * 
 * @author Giancarlo Panichi
 *
 */
public enum Status {
	RUNNING("running"), COMPLETE("complete"), FAILED("failed"), CANCELLED("cancelled");

	private Status(final String id) {
		this.id = id;
	}

	private final String id;

	@Override
	public String toString() {
		return id;
	}

	public String getLabel() {
		return id;
	}

	public static Status getStatusFromId(String id) {
		for (Status s : values()) {
			if (s.id.compareToIgnoreCase(id) == 0) {
				return s;
			}
		}
		return null;
	}

};
