package org.gcube.data.analysis.cmemsimportercl.shared.data.products;

import java.io.Serializable;
import java.util.Comparator;

/**
 * 
 * @author Giancarlo Panichi
 *
 */
public class KeywordData implements Comparator<KeywordData>, Comparable<KeywordData>, Serializable {

	private static final long serialVersionUID = 864551321365412377L;
	private String name;

	public KeywordData() {
		super();
	}

	public KeywordData(String name) {
		super();
		this.name = name;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	@Override
	public int compare(KeywordData cmemsKeywordData1, KeywordData cmemsKeywordData2) {
		return cmemsKeywordData1.compareTo(cmemsKeywordData2);
	}

	@Override
	public int compareTo(KeywordData cmemsKeywordData) {
		return this.name.compareTo(cmemsKeywordData.name);
	}

	public static class Comparators {

		// public static final Comparator<KeywordData> NAME = (KeywordData o1,
		// KeywordData o2) -> o1.name
		// .compareTo(o2.name);
		
		public static Comparator<KeywordData> NAME = new Comparator<KeywordData>() {
			@Override
			public int compare(KeywordData k1, KeywordData k2) {
				return k1.name.compareTo(k2.name);
			}
		};

	}

	@Override
	public String toString() {
		return "CmemsKeywordData [name=" + name + "]";
	}

}
