package org.gcube.data.analysis.cmemsimportercl.server.cl.command.tasks;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.gcube.data.analysis.cmemsimportercl.server.cl.command.CCmd;
import org.gcube.data.analysis.cmemsimportercl.server.util.ServiceSupportData;
import org.gcube.data.analysis.cmemsimportercl.server.util.TimeUtils;
import org.gcube.data.analysis.cmemsimportercl.shared.data.tasks.ExecutionData;
import org.gcube.data.analysis.cmemsimportercl.shared.data.tasks.ExecutionReportData;
import org.gcube.data.analysis.cmemsimportercl.shared.data.tasks.ImportOptionsData;
import org.gcube.data.analysis.cmemsimportercl.shared.data.tasks.SubmissionInfoData;
import org.gcube.data.analysis.cmemsimportercl.shared.data.tasks.ImportTaskData;
import org.gcube.data.analysis.cmemsimportercl.shared.exception.ServiceException;
import org.gcube.dataanalysis.copernicus.cmems.importer.task.ExecutionReport;
import org.gcube.dataanalysis.copernicus.cmems.importer.task.ImportTask;
import org.glassfish.jersey.client.ClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 
 * @author Giancarlo Panichi
 *
 *
 */
public class CCmdCMEMSTasks implements CCmd<ArrayList<ImportTaskData>> {
	private static final Logger logger = LoggerFactory.getLogger(CCmdCMEMSTasks.class);

	private ServiceSupportData serviceSupportData;

	public CCmdCMEMSTasks(ServiceSupportData serviceSupportData) {
		this.serviceSupportData = serviceSupportData;
		logger.debug("CCmdCMEMSTasks");
	}

	@Override
	public ArrayList<ImportTaskData> execute() throws ServiceException {
		try {
			ClientConfig config = new ClientConfig();
			config.register(serviceSupportData.getAuthFilter());
			Client client = ClientBuilder.newClient(config);
			WebTarget service = client.target(serviceSupportData.getServiceAddress());

			service = service.path("tasks");
			logger.debug("Request URI: " + service.getUri().toString());
			Response response = service.request(MediaType.APPLICATION_XML).accept(MediaType.APPLICATION_XML).get();
			
			logger.debug("Response: [" + response + "]");
			
			Collection<ImportTask> tasks = response.readEntity(new GenericType<Collection<ImportTask>>() {
			});

			ArrayList<ImportTaskData> taskDataList = new ArrayList<>();

			if (tasks != null && !tasks.isEmpty()) {

				for (ImportTask t : tasks) {

					logger.debug("Task: [" + t.getId() + " - " + t.getSubmissionInfo().getUser() + " - "
							+ t.getSubmissionInfo().getScope() + " - " + t.getImportParameters().getProduct() + " - "
							+ t.getImportParameters().getDataset() + "]");

					SubmissionInfoData submissionInfoData = new SubmissionInfoData();

					if (t.getSubmissionInfo() != null) {

						String timeScheduled = "";
						try {
							Calendar calendarScheduled = t.getSubmissionInfo().getScheduled();
							if (calendarScheduled != null) {
								timeScheduled = TimeUtils.toString(calendarScheduled);
							}
						} catch (Throwable e) {
							logger.error(e.getLocalizedMessage(), e);
						}

						submissionInfoData.setUser(t.getSubmissionInfo().getUser());
						submissionInfoData.setScope(t.getSubmissionInfo().getScope());
						submissionInfoData.setToken(t.getSubmissionInfo().getToken());
						submissionInfoData.setScheduled(timeScheduled);

					}

					ImportOptionsData importOptionData = new ImportOptionsData();

					if (t.getImportParameters() != null) {

						String timeTLo = "";
						try {
							Calendar calendarTLo = t.getImportParameters().gettLo();
							if (calendarTLo != null) {
								timeTLo = TimeUtils.toString(calendarTLo);
							}
						} catch (Throwable e) {
							logger.error(e.getLocalizedMessage(), e);
						}

						String timeTHi = "";
						try {
							Calendar calendarTHi = t.getImportParameters().gettHi();
							if (calendarTHi != null) {
								timeTHi = TimeUtils.toString(calendarTHi);
							}
						} catch (Throwable e) {
							logger.error(e.getLocalizedMessage(), e);
						}
						
						int backTime=0;
						if(t.getImportParameters().getBackTime()!=null){
							backTime=t.getImportParameters().getBackTime();
						}
						
						importOptionData.setBackTime(backTime);
						importOptionData.setDataset(t.getImportParameters().getDataset());
						importOptionData.setImportSchedule(t.getImportParameters().getImportSchedule());
						importOptionData.setMotu(t.getImportParameters().getMotu());
						importOptionData.setProduct(t.getImportParameters().getProduct());
						
						if(t.getImportParameters().getChunkSpan()!=null){
							importOptionData.setChunkSpan(t.getImportParameters().getChunkSpan().toString());
						}
						
						importOptionData.settLo(timeTLo);
						importOptionData.settHi(timeTHi);

						ArrayList<String> variables = new ArrayList<>();

						if (t.getImportParameters().getVariables() != null) {
							variables.addAll(t.getImportParameters().getVariables());
						}
						importOptionData.setVariables(variables);
						importOptionData.setxLo(t.getImportParameters().getxLo());
						importOptionData.setxHi(t.getImportParameters().getxHi());
						importOptionData.setyLo(t.getImportParameters().getyLo());
						importOptionData.setyHi(t.getImportParameters().getyHi());
						importOptionData.setzLo(t.getImportParameters().getzLo());
						importOptionData.setzHi(t.getImportParameters().getzHi());

					}

					ExecutionData executionData = new ExecutionData();

					if (t.getLastExecution() != null) {
						String timeBegin = null;
						try {
							Calendar calendarBegin = t.getLastExecution().getBegin();
							if (calendarBegin != null) {
								timeBegin = TimeUtils.toString(t.getLastExecution().getBegin());
							}
						} catch (Throwable e) {
							logger.error(e.getLocalizedMessage(), e);
						}

						String timeEnd = null;
						try {
							Calendar calendarEnd = t.getLastExecution().getEnd();
							if (calendarEnd != null) {
								timeEnd = TimeUtils.toString(t.getLastExecution().getEnd());
							}
						} catch (Throwable e) {
							logger.error(e.getLocalizedMessage(), e);
						}

						String timeLast = null;
						try {
							Calendar calendarLast = t.getLastExecution().getLastUpdate();
							if (calendarLast != null) {
								timeLast = TimeUtils.toString(t.getLastExecution().getLastUpdate());
							}
						} catch (Throwable e) {
							logger.error(e.getLocalizedMessage(), e);
						}

						executionData.setId(t.getLastExecution().getId());
						executionData.setBegin(timeBegin);
						executionData.setEnd(timeEnd);
						executionData.setLastUpdate(timeLast);
						executionData.setStatus(t.getLastExecution().getStatus().value());
						executionData.setProgress(t.getLastExecution().getProgress());

						ArrayList<ExecutionReportData> reports = new ArrayList<>();

						if (t.getLastExecution().getReports() != null && !t.getLastExecution().getReports().isEmpty()) {

							for (ExecutionReport r : t.getLastExecution().getReports()) {
								ExecutionReportData report = new ExecutionReportData(r.getName(), r.getText(),
										r.getSnippet(), r.getSize());
								reports.add(report);
							}
						}
						executionData.setReports(reports);

					}

					ImportTaskData taskData = new ImportTaskData(t.getId(), submissionInfoData, importOptionData, executionData);

					taskDataList.add(taskData);

				}

			}

			return taskDataList;

		} catch (Throwable e) {
			logger.error("Error in CCmdCMEMSTaks(): " + e.getLocalizedMessage(), e);
			throw new ServiceException("Error in CCmdCMEMSTasks(): " + e.getLocalizedMessage(), e);

		}
	}

}
