package org.gcube.data.analysis.cmemsimportercl.server.cl.command.tasks;

import java.util.ArrayList;
import java.util.Collection;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.gcube.data.analysis.cmemsimportercl.server.cl.command.CCmd;
import org.gcube.data.analysis.cmemsimportercl.server.util.ServiceSupportData;
import org.gcube.data.analysis.cmemsimportercl.shared.data.tasks.ExecutionReportData;
import org.gcube.data.analysis.cmemsimportercl.shared.exception.ServiceException;
import org.gcube.dataanalysis.copernicus.cmems.importer.task.ExecutionReport;
import org.glassfish.jersey.client.ClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 
 * @author Giancarlo Panichi
 *
 *
 */
public class CCmdCMEMSReports implements CCmd<ArrayList<ExecutionReportData>> {
	private static final Logger logger = LoggerFactory.getLogger(CCmdCMEMSReports.class);

	private ServiceSupportData serviceSupportData;
	private String taskId;
	private String executionId;

	public CCmdCMEMSReports(ServiceSupportData serviceSupportData, String taskId, String executionId) {
		this.serviceSupportData = serviceSupportData;
		this.taskId = taskId;
		this.executionId = executionId;
		logger.debug("CCmdCMEMSReports: [taskId=" + taskId + ", executionId=" + executionId + "]");
	}

	@Override
	public ArrayList<ExecutionReportData> execute() throws ServiceException {
		try {
			if (taskId == null || taskId.isEmpty()) {
				logger.error("Error in CCmdCMEMSReports(), invalid task id: " + taskId);
				throw new ServiceException("Error in CCmdCMEMSExecutions(), invalid task id: " + taskId);
			}

			if (executionId == null || executionId.isEmpty()) {
				logger.error("Error in CCmdCMEMSReports(), invalid execution Id: " + executionId);
				throw new ServiceException("Error in CCmdCMEMSReports(), invalid execution id: " + executionId);
			}

			ClientConfig config = new ClientConfig();
			config.register(serviceSupportData.getAuthFilter());
			Client client = ClientBuilder.newClient(config);
			WebTarget service = client.target(serviceSupportData.getServiceAddress());

			service = service.path("tasks").path(taskId).path("executions").path(executionId).path("reports");
			logger.debug("Request URI: " + service.getUri().toString());
			Response response = service.request(MediaType.APPLICATION_XML).accept(MediaType.APPLICATION_XML).get();

			logger.debug("Response: [" + response + "]");

			Collection<ExecutionReport> reports = response
					.readEntity(new GenericType<Collection<ExecutionReport>>() {
					});

			ArrayList<ExecutionReportData> executionReportDataList = new ArrayList<>();

			if (reports != null && !reports.isEmpty()) {

				for (ExecutionReport r : reports) {
					logger.debug("ExecutionReport: [" + r.getName() + "]");

					ExecutionReportData report = new ExecutionReportData(r.getName(), r.getText(), r.getSnippet(),
							r.getSize());
					executionReportDataList.add(report);
				}
			} 
			return executionReportDataList;

		} catch (Throwable e) {
			logger.error("Error in CCmdCMEMSReports(): " + e.getLocalizedMessage(), e);
			throw new ServiceException("Error in CCmdCMEMSReports(): " + e.getLocalizedMessage(), e);

		}
	}

}
