package org.gcube.data.analysis.cmemsimportercl.server.cl.command.products;

import java.util.ArrayList;
import java.util.Collection;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.gcube.data.analysis.cmemsimportercl.server.cl.command.CCmd;
import org.gcube.data.analysis.cmemsimportercl.server.util.ServiceSupportData;
import org.gcube.data.analysis.cmemsimportercl.server.util.TimeUtils;
import org.gcube.data.analysis.cmemsimportercl.shared.data.products.DocumentData;
import org.gcube.data.analysis.cmemsimportercl.shared.data.products.KeywordData;
import org.gcube.data.analysis.cmemsimportercl.shared.data.products.ProductData;
import org.gcube.data.analysis.cmemsimportercl.shared.data.products.RegionData;
import org.gcube.data.analysis.cmemsimportercl.shared.data.products.VariableData;
import org.gcube.data.analysis.cmemsimportercl.shared.exception.ServiceException;
import org.gcube.dataanalysis.copernicus.cmems.model.CmemsDataset;
import org.gcube.dataanalysis.copernicus.cmems.model.CmemsDocument;
import org.gcube.dataanalysis.copernicus.cmems.model.CmemsKeyword;
import org.gcube.dataanalysis.copernicus.cmems.model.CmemsProduct;
import org.gcube.dataanalysis.copernicus.cmems.model.CmemsRegion;
import org.gcube.dataanalysis.copernicus.cmems.model.CmemsVariable;
import org.glassfish.jersey.client.ClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 
 * @author Giancarlo Panichi
 *
 *
 */
public class CCmdCMEMSProducts implements CCmd<ArrayList<ProductData>> {
	private static final Logger logger = LoggerFactory.getLogger(CCmdCMEMSProducts.class);

	private ServiceSupportData serviceSupportData;

	public CCmdCMEMSProducts(ServiceSupportData serviceSupportData) {
		this.serviceSupportData = serviceSupportData;
		logger.debug("CCmdCMEMSProducts");
	}

	@Override
	public ArrayList<ProductData> execute() throws ServiceException {
		try {
			ClientConfig config = new ClientConfig();
			config.register(serviceSupportData.getAuthFilter());
			Client client = ClientBuilder.newClient(config);
			WebTarget service = client.target(serviceSupportData.getServiceAddress());

			// Create Request
			/*
			 * String products =service.path("products").request()
			 * .accept(MediaType.APPLICATION_XML).get(String.class);
			 **/

			/*
			 * Response response =
			 * service.path("products").request().accept(MediaType.
			 * APPLICATION_XML).get();
			 * 
			 * Collection<CmemsProduct> products = response.readEntity(new
			 * GenericType<Collection<CmemsProduct>>() { });
			 */

			service = service.path("/cmems").path("products");
			logger.debug("Request URI: " + service.getUri().toString());
			Response response = service.request(MediaType.APPLICATION_XML).accept(MediaType.APPLICATION_XML).get();

			logger.debug("Response: [" + response + "]");

			Collection<CmemsProduct> products = response.readEntity(new GenericType<Collection<CmemsProduct>>() {
			});

			ArrayList<ProductData> productDataList = new ArrayList<>();

			if (products != null && !products.isEmpty()) {

				for (CmemsProduct p : products) {

					logger.debug("Product: [" + p.getId() + " - " + p.getExternalShortname() + " - "
							+p.getCreationDate()+" - "+ p.getFeatureType() + " - " + p.getQuicklooks());

					StringBuilder sFtp = new StringBuilder();
					if (p.getFtpDatasets() != null) {
						boolean sFtpFirst = true;
						for (CmemsDataset dFtp : p.getFtpDatasets()) {
							if (sFtpFirst) {
								sFtp.append(dFtp.getName());
								sFtpFirst = false;
							} else {
								sFtp.append(" ");
								sFtp.append(dFtp.getName());
							}
						}
					}

					StringBuilder sDgf = new StringBuilder();
					if (p.getDgfDatasets() != null) {
						boolean sDgfFirst = true;
						for (CmemsDataset dDgf : p.getDgfDatasets()) {
							if (sDgfFirst) {
								sDgf.append(dDgf.getName());
								sDgfFirst = false;
							} else {
								sDgf.append(" ");
								sDgf.append(dDgf.getName());
							}
						}
					}

					StringBuilder sTds = new StringBuilder();
					if (p.getTdsDatasets() != null) {
						boolean sTdsFirst = true;
						for (CmemsDataset dTds : p.getTdsDatasets()) {
							if (sTdsFirst) {
								sTds.append(dTds.getName());
								sTdsFirst = false;
							} else {
								sTds.append(" ");
								sTds.append(dTds.getName());
							}
						}
					}

					StringBuilder sWms = new StringBuilder();
					if (p.getWmsDatasets() != null) {
						boolean sWmsFirst = true;
						for (CmemsDataset dWms : p.getWmsDatasets()) {
							if (sWmsFirst) {
								sWms.append(dWms.getName());
								sWmsFirst = false;
							} else {
								sWms.append(" ");
								sWms.append(dWms.getName());
							}
						}
					}

					ArrayList<KeywordData> keys = new ArrayList<>();
					for (CmemsKeyword k : p.getAllKeywords()) {
						KeywordData kData = new KeywordData(k.getName());
						keys.add(kData);
					}

					ArrayList<RegionData> geoAreas = new ArrayList<>();
					for (CmemsRegion r : p.getGeographicalArea()) {
						RegionData rData = new RegionData(r.getName());
						geoAreas.add(rData);
					}

					ArrayList<KeywordData> oceanKeys = new ArrayList<>();
					for (CmemsKeyword k : p.getOceanKeys()) {
						KeywordData kData = new KeywordData(k.getName());
						oceanKeys.add(kData);
					}

					ArrayList<VariableData> oceanVariables = new ArrayList<>();
					for (CmemsVariable v : p.getOceanVariables()) {
						VariableData vData = new VariableData(v.getName());
						oceanVariables.add(vData);
					}

					ArrayList<DocumentData> documents = new ArrayList<>();
					int i = 0;
					for (CmemsDocument v : p.getDocumentation()) {
						i++;
						DocumentData vData = new DocumentData(i, v.getTitle(), v.getUrl(), v.getDate());
						documents.add(vData);
					}

					ProductData productData = new ProductData(p.getId(), p.getExternalShortname(), p.getAbstract(),
							p.getDisplayPriority(), p.getVersion(), p.getShortDescription(),
							TimeUtils.toString(p.getCreationDate()), TimeUtils.toString(p.getUpdateDate()),
							p.getQuicklooks(), p.getFeatureType(), p.getForecastLength(), keys, geoAreas,
							p.getMissionType(), p.getModelAssimilation(), oceanVariables, oceanKeys,
							p.getProcessingLevel(), p.getWest(), p.getEast(), p.getSouth(), p.getNorth(),
							p.getSpatialResolutionRow(), p.getSpatialResolutionRowUnit(),
							p.getSpatialResolutionColumn(), p.getSpatialResolutionColumnUnit(), p.getCoordRefSys(),
							p.getVerticalMin(), p.getVerticalMax(), p.getVerticalCrs(), p.getVerticalLevels(),
							p.getTemporalResolution(), p.getVerticalCoverage(),
							TimeUtils.toString(p.getTemporalBegin()), TimeUtils.toString(p.getTemporalEnd()),
							p.getTemporalExtent(), p.getTemporalScale(), p.getUpdateFrequency(), p.getUpdateSchedule(),
							p.getProductionUnit(), p.getCredit(), documents, p.getMail(), sFtp.toString(),
							sDgf.toString(), sTds.toString(), sWms.toString(), p.getServiceDesk(),
							p.getUpstreamProduction(), p.getUpstreamValidation(), p.getDownstreamValidation(),
							p.getDownstreamProduction(), p.getMYO_OK(), p.getVersion());

					productDataList.add(productData);

				}

			}

			return productDataList;

		} catch (Throwable e) {
			logger.error("Error in CCmdCMEMSProducts(): " + e.getLocalizedMessage(), e);
			throw new ServiceException("Error in CCmdCMEMSProducts(): " + e.getLocalizedMessage(), e);

		}
	}

}
