package org.gcube.data.analysis.cmemsimportercl.shared.data.tasks;

import java.io.Serializable;

/**
 * 
 * @author Giancarlo Panichi
 *
 *
 */
public class SubmissionInfoData implements Serializable {

	private static final long serialVersionUID = 1049914230633395584L;
	/**
	 * The gcube scope where the task was scheduled
	 */
	private String scope;

	/**
	 * The token of the user/application scheduling the task
	 */
	private String token;

	/**
	 * The user who scheduled the task
	 */
	private String user;

	/**
	 * The time when the task was scheduled
	 */
	private String scheduled;

	public SubmissionInfoData() {
		super();
	}

	public SubmissionInfoData(String scope, String token, String user, String scheduled) {
		super();
		this.scope = scope;
		this.token = token;
		this.user = user;
		this.scheduled = scheduled;
	}

	public String getScope() {
		return scope;
	}

	public void setScope(String scope) {
		this.scope = scope;
	}

	public String getToken() {
		return token;
	}

	public void setToken(String token) {
		this.token = token;
	}

	public String getUser() {
		return user;
	}

	public void setUser(String user) {
		this.user = user;
	}

	public String getScheduled() {
		return scheduled;
	}

	public void setScheduled(String scheduled) {
		this.scheduled = scheduled;
	}

	@Override
	public String toString() {
		return "SubmissionInfoData [scope=" + scope + ", token=" + token + ", user=" + user + ", scheduled=" + scheduled
				+ "]";
	}

}
