package org.gcube.data.analysis.cmemsimportercl.server.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;

import org.gcube.data.analysis.cmemsimportercl.shared.exception.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 
 * @author Giancarlo Panichi
 *
 */
public class TimeUtils {
	
	private static final Logger logger = LoggerFactory
			.getLogger(TimeUtils.class);

	
	public static String toString(Calendar c) {
		SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
		if(c==null){
			return "";
		} else {
			return format.format(c.getTime());
		}
	}

	public static Calendar toCalendar(String s) throws ServiceException {
		String[] formats = { "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd", "yyyyMMdd", "yyyyMM",
				"yyyy" };
		for (String f : formats) {
			SimpleDateFormat format = new SimpleDateFormat(f);
			Calendar c = Calendar.getInstance();
			try {
				c.setTime(format.parse(s));
				return c;
			} catch (ParseException e) {
				continue;
			}
		}
		logger.error("Invalid Time Format: "+s);
		throw new ServiceException("Invalid Time Format: "+s);
	}

}
