package org.gcube.data.analysis.cmemsimportercl.shared.data.products;

/**
 * 
 * @author Giancarlo Panichi
 *
 */
public enum DatasetType {
	TDS("tds"),
	WMS("wms"), 
	FTP("ftp"),
	DGF("dgf");
	
	
	private DatasetType(final String id) {
		this.id = id;
	}

	private final String id;
	
	@Override
	public String toString() {
		return id;
	}
	
	public String getLabel() {
		return id;
	}
	
	
	public static DatasetType getDatasetTypeFromId(String id) {
		for (DatasetType type : values()) {
			if (type.id.compareToIgnoreCase(id) == 0) {
				return type;
			}
		}
		return null;
	}
}
