package org.gcube.data.analysis.cmemsimportercl.server.monitor;

import java.util.ArrayList;
import java.util.TimerTask;

import org.gcube.data.analysis.cmemsimportercl.server.cl.CClient;
import org.gcube.data.analysis.cmemsimportercl.shared.data.tasks.ExecutionData;
import org.gcube.data.analysis.cmemsimportercl.shared.exception.ServiceException;
import org.gcube.data.analysis.cmemsimportercl.shared.execution.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 
 * @author Giancarlo Panichi
 *
 *
 */
public class CMonitorTask extends TimerTask {
	private static Logger logger = LoggerFactory.getLogger(CMonitorTask.class);
	private ArrayList<CMonitorListener> listeners;
	private String taskId;
	private String executionId;
	private CClient cClient;
	private CMonitor sMonitor;

	public CMonitorTask(CMonitor sMonitor, String taskId, String executionId, CClient cClient,
			ArrayList<CMonitorListener> listeners) {
		this.taskId=taskId;
		this.executionId = executionId;
		this.cClient = cClient;
		this.listeners = listeners;
		this.sMonitor=sMonitor;
		logger.debug("SMonitorTask");

	}

	/**
	 * {@inheritDoc}
	 */
	public void run() {
		logger.debug("Requesting execution progress");
		ExecutionData executionData = null;
		try {
			executionData = cClient.executionInfo(taskId, executionId);
		} catch (Exception e) {
			logger.error(e.getLocalizedMessage());
			e.printStackTrace();

		}
		logger.debug("ExecutionData: " + executionData);
		if (executionData == null) {
			logger.error("ExecutionData is null");
			return;
		}

		String statusValue = executionData.getStatus();
		if (statusValue == null) {
			logger.error("Status is null");
			return;
		}

		Status status=Status.getStatusFromId(statusValue);
		
		switch (status) {
		case CANCELLED:
			sMonitor.cancel();
			fireCancelled(executionData);
			break;
		case COMPLETE:
			sMonitor.cancel();
			fireCompleted(executionData);
			break;
		case FAILED:
			sMonitor.cancel();
			fireFailed(executionData);
			break;
		case RUNNING:
			fireRunning(executionData);
			break;
		default:
			break;

		}

	}


	private void fireCancelled(ExecutionData computationStatus) {
		for (CMonitorListener listener : listeners)
			listener.cancelled();
	}

	private void fireCompleted(ExecutionData computationStatus) {
		for (CMonitorListener listener : listeners)
			listener.completed();
	}

	private void fireFailed(ExecutionData computationStatus) {
		for (CMonitorListener listener : listeners)
			listener.failed(new ServiceException(computationStatus.getStatus()));
	}

	private void fireRunning(ExecutionData computationStatus) {
		for (CMonitorListener listener : listeners)
			listener.running(computationStatus.getProgress());
	}

}
