package org.gcube.data.analysis.cmemsimportercl.server.cl.command.tasks;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;

import org.gcube.data.analysis.cmemsimportercl.server.cl.command.CCmd;
import org.gcube.data.analysis.cmemsimportercl.server.util.ServiceSupportData;
import org.gcube.data.analysis.cmemsimportercl.shared.data.tasks.ImportOptionsData;
import org.gcube.data.analysis.cmemsimportercl.shared.exception.ServiceException;
import org.glassfish.jersey.client.ClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 
 * @author Giancarlo Panichi
 *
 *
 */
public class CCmdCMEMSPreviewSize implements CCmd<String> {
	private static final Logger logger = LoggerFactory.getLogger(CCmdCMEMSPreviewSize.class);

	private ServiceSupportData serviceSupportData;
	private ImportOptionsData importOptionsData;

	public CCmdCMEMSPreviewSize(ServiceSupportData serviceSupportData, ImportOptionsData importOptionsData) {
		this.serviceSupportData = serviceSupportData;
		this.importOptionsData = importOptionsData;
		logger.debug("CCmdCMEMSPreviewSize");
		logger.debug("ImportOptionsData: " + importOptionsData);
	}

	@Override
	public String execute() throws ServiceException {
		try {
			ClientConfig config = new ClientConfig();
			config.register(serviceSupportData.getAuthFilter());
			Client client = ClientBuilder.newClient(config);
			WebTarget service = client.target(serviceSupportData.getServiceAddress());

			service = service.path("tasks").path("preview").path("sizes").path("dataset");

			if (importOptionsData.getProduct() != null) {
				service=service.queryParam("p", importOptionsData.getProduct());
			} else {
				throw new ServiceException("Invalid Product: null");
			}

			if (importOptionsData.getDataset() != null) {
				service=service.queryParam("d", importOptionsData.getDataset());
			} else {
				throw new ServiceException("Invalid Dataset: null");
			}

			if (importOptionsData.getMotu() != null) {
				service=service.queryParam("m", importOptionsData.getMotu());
			}

			if (importOptionsData.getVariables() != null) {
				service=service.queryParam("v", importOptionsData.getVariables());
			}

			if (importOptionsData.gettLo() != null) {
				service=service.queryParam("tlo", importOptionsData.gettLo());
			}
			if (importOptionsData.gettHi() != null) {
				service=service.queryParam("thi", importOptionsData.gettHi());
			}
			if (importOptionsData.getxLo() != null) {
				service=service.queryParam("xlo", importOptionsData.getxLo());
			}
			if (importOptionsData.getxHi() != null) {
				service=service.queryParam("xhi", importOptionsData.getxHi());
			}

			if (importOptionsData.getyLo() != null) {
				service=service.queryParam("ylo", importOptionsData.getyLo());
			}
			if (importOptionsData.getyHi() != null) {
				service=service.queryParam("yhi", importOptionsData.getyHi());
			}
			if (importOptionsData.getzLo() != null) {
				service=service.queryParam("zlo", importOptionsData.getzLo());
			}
			if (importOptionsData.getzHi() != null) {
				service=service.queryParam("zhi", importOptionsData.getzHi());
			}

			logger.debug("Request URI: " + service.getUri().toString());
		
			Response response = service.request().get();
			logger.debug("Response: [" + response + "]");

			String size=response.readEntity(String.class);
			logger.debug("Size: [" + size + "]");

			
			return size;

		} catch (Throwable e) {
			logger.error("Error in CCmdCMEMSPreviewDataset(): " + e.getLocalizedMessage(), e);
			throw new ServiceException("Error in CCmdCMEMSPreviewDataset(): " + e.getLocalizedMessage(), e);

		}
	}

}
