package org.gcube.data.analysis.cmemsimportercl.server.cl.command.tasks;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.gcube.data.analysis.cmemsimportercl.server.cl.command.CCmd;
import org.gcube.data.analysis.cmemsimportercl.server.util.ServiceSupportData;
import org.gcube.data.analysis.cmemsimportercl.server.util.TimeUtils;
import org.gcube.data.analysis.cmemsimportercl.shared.data.tasks.ExecutionData;
import org.gcube.data.analysis.cmemsimportercl.shared.data.tasks.ExecutionReportData;
import org.gcube.data.analysis.cmemsimportercl.shared.exception.ServiceException;
import org.gcube.dataanalysis.copernicus.cmems.importer.task.Execution;
import org.gcube.dataanalysis.copernicus.cmems.importer.task.ExecutionReport;
import org.glassfish.jersey.client.ClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 
 * @author Giancarlo Panichi
 *
 *
 */
public class CCmdCMEMSExecutions implements CCmd<ArrayList<ExecutionData>> {
	private static final Logger logger = LoggerFactory.getLogger(CCmdCMEMSExecutions.class);

	private ServiceSupportData serviceSupportData;
	private String taskId;

	public CCmdCMEMSExecutions(ServiceSupportData serviceSupportData, String taskId) {
		this.serviceSupportData = serviceSupportData;
		this.taskId = taskId;
		logger.debug("CCmdCMEMSExecutions: [taskId=" + taskId + "]");
	}

	@Override
	public ArrayList<ExecutionData> execute() throws ServiceException {
		try {
			if (taskId == null || taskId.isEmpty()) {
				logger.error("Error in CCmdCMEMSExecutions(), invalid task id: " + taskId);
				throw new ServiceException("Error in CCmdCMEMSExecutions(), invalid task id: " + taskId);
			}
			
			ClientConfig config = new ClientConfig();
			config.register(serviceSupportData.getAuthFilter());
			Client client = ClientBuilder.newClient(config);
			WebTarget service = client.target(serviceSupportData.getServiceAddress());

			service = service.path("tasks").path(taskId).path("executions");
			logger.debug("Request URI: " + service.getUri().toString());
			Response response = service.request(MediaType.APPLICATION_XML).accept(MediaType.APPLICATION_XML).get();

			logger.debug("Response: [" + response + "]");

			Collection<Execution> executions = response.readEntity(new GenericType<Collection<Execution>>() {
			});

			ArrayList<ExecutionData> executionDataList = new ArrayList<>();

			if (executions != null && !executions.isEmpty()) {

				for (Execution t : executions) {
					logger.debug("Execution: [" + t.getId()  + "]");

					ExecutionData executionData = new ExecutionData();
					
					String timeBegin = null;
					try {
						Calendar calendarBegin = t.getBegin();
						if (calendarBegin != null) {
							timeBegin = TimeUtils.toString(t.getBegin());
						}
					} catch (Throwable e) {
						logger.error(e.getLocalizedMessage(), e);
					}

					String timeEnd = null;
					try {
						Calendar calendarEnd = t.getEnd();
						if (calendarEnd != null) {
							timeEnd = TimeUtils.toString(t.getEnd());
						}
					} catch (Throwable e) {
						logger.error(e.getLocalizedMessage(), e);
					}

					String timeLast = null;
					try {
						Calendar calendarLast = t.getLastUpdate();
						if (calendarLast != null) {
							timeLast = TimeUtils.toString(t.getLastUpdate());
						}
					} catch (Throwable e) {
						logger.error(e.getLocalizedMessage(), e);
					}

					executionData.setId(t.getId());
					executionData.setBegin(timeBegin);
					executionData.setEnd(timeEnd);
					executionData.setLastUpdate(timeLast);
					executionData.setStatus(t.getStatus().value());
					executionData.setProgress(t.getProgress());

					ArrayList<ExecutionReportData> reports = new ArrayList<>();

					if (t.getReports() != null && !t.getReports().isEmpty()) {

						for (ExecutionReport r : t.getReports()) {
							ExecutionReportData report = new ExecutionReportData(r.getName(), r.getText(),
									r.getSnippet(), r.getSize());
							reports.add(report);
						}
					}
					executionData.setReports(reports);
					executionDataList.add(executionData);
				}

			}

			return executionDataList;

		} catch (Throwable e) {
			logger.error("Error in CCmdCMEMSExecutions(): " + e.getLocalizedMessage(), e);
			throw new ServiceException("Error in CCmdCMEMSExecutions(): " + e.getLocalizedMessage(), e);

		}
	}

}
