package org.gcube.data.analysis.cmemsimportercl.server.cl.command.products;

import java.util.ArrayList;
import java.util.List;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.gcube.data.analysis.cmemsimportercl.server.cl.command.CCmd;
import org.gcube.data.analysis.cmemsimportercl.server.util.ServiceSupportData;
import org.gcube.data.analysis.cmemsimportercl.shared.data.products.DatasetData;
import org.gcube.data.analysis.cmemsimportercl.shared.data.products.DatasetType;
import org.gcube.data.analysis.cmemsimportercl.shared.exception.ServiceException;
import org.gcube.dataanalysis.copernicus.cmems.model.CmemsDataset;
import org.glassfish.jersey.client.ClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 
 * @author Giancarlo Panichi
 *
 *
 */
public class CCmdCMEMSDatasets implements CCmd<ArrayList<DatasetData>> {
	private static final Logger logger = LoggerFactory.getLogger(CCmdCMEMSDatasets.class);

	private ServiceSupportData serviceSupportData;

	private String productId;

	public CCmdCMEMSDatasets(ServiceSupportData serviceSupportData, String productId) {
		this.serviceSupportData = serviceSupportData;
		this.productId = productId;
		logger.debug("CCmdCMEMSDatasets: [product=" + productId + "]");
	}

	@Override
	public ArrayList<DatasetData> execute() throws ServiceException {
		try {
			if (productId == null || productId.isEmpty()) {
				logger.error("Error in CCmdCMEMSDatasets, invalid product: " + productId);
				throw new ServiceException("Error in CCmdCMEMSDatasets, invalid product: " + productId);

			}

			ClientConfig config = new ClientConfig();
			config.register(serviceSupportData.getAuthFilter());
			Client client = ClientBuilder.newClient(config);

			ArrayList<DatasetData> datasetDataList = new ArrayList<>();

			int i = 1;
			// Create Request
			for (DatasetType datasetType : DatasetType.values()) {
				logger.debug("Search: " + datasetType);
				WebTarget service = client.target(serviceSupportData.getServiceAddress());
				service = service.path("/cmems").path("products").path(productId).path("datasets")
						.path(datasetType.getLabel());
				logger.debug("Request URI: " + service.getUri().toString());

				try {
					Response response = service.request().accept(MediaType.APPLICATION_XML).get();

					List<CmemsDataset> datasets = response.readEntity(new GenericType<List<CmemsDataset>>() {
					});

					if (datasets != null && !datasets.isEmpty()) {
						for (CmemsDataset d : datasets) {
							logger.debug("CmemsDataset: [" + d.getName() + " - " + d.getProtocol() + " - " + d.getUrl()
									+ "- " + "]");
							String motuUrl = d.getUrl();
							int index = motuUrl.indexOf("Motu?");
							if (index > 5) {
								motuUrl = motuUrl.substring(0, index + 5);
							} else {
								motuUrl = "";
							}
							DatasetData datasetData = new DatasetData(i, d.getName(), datasetType, d.getProtocol(),
									motuUrl);
							i++;
							datasetDataList.add(datasetData);

						}
					}
				} catch (Throwable e) {
					logger.error("Error in CCmdCMEMSDatasets() : Requested=" + datasetType + ",  Error="
							+ e.getLocalizedMessage(), e);
				}

			}

			return datasetDataList;

		} catch (Throwable e) {
			logger.error("Error in CCmdCMEMSDatasets(): " + e.getLocalizedMessage(), e);
			throw new ServiceException("Error in CCmdCMEMSDatasets(): " + e.getLocalizedMessage(), e);

		}
	}

}
