package org.gcube.data.analysis.cmemsimportercl.shared.data.products;

import java.io.Serializable;
import java.util.ArrayList;

/**
 * 
 * @author Giancarlo Panichi
 *
 */
public class DatasetInfoData implements Serializable {

	private static final long serialVersionUID = -2535869921268587732L;
	private String code;
	private String msg;
	private String lastUpdate;
	private String url;
	private String title;
	private String id;
	private String rawAvailableTimeCodes;
	private String rawAvailableDepths;
	private TimeCoverageData timeCoverage;
	private ArrayList<VariableInfoData> variables;
	private ArrayList<AxisData> dataGeospatialCoverage;

	public DatasetInfoData() {
		super();
	}

	public DatasetInfoData(String code, String msg, String lastUpdate, String url, String title, String id,
			String rawAvailableTimeCodes, String rawAvailableDepths, TimeCoverageData timeCoverage,
			ArrayList<VariableInfoData> variables, ArrayList<AxisData> dataGeospatialCoverage) {
		super();
		this.code = code;
		this.msg = msg;
		this.lastUpdate = lastUpdate;
		this.url = url;
		this.title = title;
		this.id = id;
		this.rawAvailableTimeCodes = rawAvailableTimeCodes;
		this.rawAvailableDepths = rawAvailableDepths;
		this.timeCoverage = timeCoverage;
		this.variables = variables;
		this.dataGeospatialCoverage = dataGeospatialCoverage;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getMsg() {
		return msg;
	}

	public void setMsg(String msg) {
		this.msg = msg;
	}

	public String getLastUpdate() {
		return lastUpdate;
	}

	public void setLastUpdate(String lastUpdate) {
		this.lastUpdate = lastUpdate;
	}

	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getRawAvailableTimeCodes() {
		return rawAvailableTimeCodes;
	}

	public void setRawAvailableTimeCodes(String rawAvailableTimeCodes) {
		this.rawAvailableTimeCodes = rawAvailableTimeCodes;
	}

	public String getRawAvailableDepths() {
		return rawAvailableDepths;
	}

	public void setRawAvailableDepths(String rawAvailableDepths) {
		this.rawAvailableDepths = rawAvailableDepths;
	}

	public TimeCoverageData getTimeCoverage() {
		return timeCoverage;
	}

	public void setTimeCoverage(TimeCoverageData timeCoverage) {
		this.timeCoverage = timeCoverage;
	}

	public ArrayList<VariableInfoData> getVariables() {
		return variables;
	}

	public void setVariables(ArrayList<VariableInfoData> variables) {
		this.variables = variables;
	}

	public ArrayList<AxisData> getDataGeospatialCoverage() {
		return dataGeospatialCoverage;
	}

	public void setDataGeospatialCoverage(ArrayList<AxisData> dataGeospatialCoverage) {
		this.dataGeospatialCoverage = dataGeospatialCoverage;
	}

	@Override
	public String toString() {
		return "DatasetInfoData [code=" + code + ", msg=" + msg + ", lastUpdate=" + lastUpdate + ", url=" + url
				+ ", title=" + title + ", id=" + id + ", rawAvailableTimeCodes=" + rawAvailableTimeCodes
				+ ", rawAvailableDepths=" + rawAvailableDepths + ", timeCoverage=" + timeCoverage + ", variables="
				+ variables + ", dataGeospatialCoverage=" + dataGeospatialCoverage + "]";
	}

}
