package org.gcube.data.analysis.cmemsimportercl.server.cl.command.products;

import java.util.ArrayList;
import java.util.List;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.gcube.data.analysis.cmemsimportercl.server.cl.command.CCmd;
import org.gcube.data.analysis.cmemsimportercl.server.util.ServiceSupportData;
import org.gcube.data.analysis.cmemsimportercl.shared.data.products.VariableData;
import org.gcube.data.analysis.cmemsimportercl.shared.exception.ServiceException;
import org.gcube.dataanalysis.copernicus.cmems.model.CmemsVariable;
import org.glassfish.jersey.client.ClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 
 * @author Giancarlo Panichi
 *
 *
 */
public class CCmdCMEMSVariables implements CCmd<ArrayList<VariableData>> {
	private static final Logger logger = LoggerFactory.getLogger(CCmdCMEMSVariables.class);

	private ServiceSupportData serviceSupportData;

	public CCmdCMEMSVariables(ServiceSupportData serviceSupportData) {
		this.serviceSupportData = serviceSupportData;
		logger.debug("CCmdCMEMSVariables");
	}

	@Override
	public ArrayList<VariableData> execute() throws ServiceException {
		try {
			ClientConfig config = new ClientConfig();
			config.register(serviceSupportData.getAuthFilter());
			Client client = ClientBuilder.newClient(config);
			WebTarget service = client.target(serviceSupportData.getServiceAddress());

			// Create Request
			service = service.path("/cmems").path("variables");
			logger.debug("Request URI: " + service.getUri().toString());

			Response response = service.request(MediaType.APPLICATION_XML).accept(MediaType.APPLICATION_XML).get();
			
			logger.debug("Response: [" + response + "]");
			
			List<CmemsVariable> variables = response.readEntity(new GenericType<List<CmemsVariable>>() {
			});

			ArrayList<VariableData> variableDataList = new ArrayList<>();

			if (variables != null && !variables.isEmpty()) {

				for (CmemsVariable v : variables) {

					logger.debug("Variable: [" + v.getName() + "]");
					VariableData variableData = new VariableData(v.getName());

					variableDataList.add(variableData);
				}

			}

			return variableDataList;

		} catch (Throwable e) {
			logger.error("Error in CCmdCMEMSVariables(): " + e.getLocalizedMessage(), e);
			throw new ServiceException("Error in CCmdCMEMSVariables(): " + e.getLocalizedMessage(), e);

		}
	}

}
