package org.gcube.data.analysis.cmemsimportercl.server.cl.command.products;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;

import org.gcube.data.analysis.cmemsimportercl.server.cl.command.CCmd;
import org.gcube.data.analysis.cmemsimportercl.server.util.ServiceSupportData;
import org.gcube.data.analysis.cmemsimportercl.shared.data.products.TimeLimitsData;
import org.gcube.data.analysis.cmemsimportercl.shared.exception.ServiceException;
import org.glassfish.jersey.client.ClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 
 * @author Giancarlo Panichi
 *
 *
 */
public class CCmdCMEMSTimeLimits implements CCmd<TimeLimitsData> {
	private static final Logger logger = LoggerFactory.getLogger(CCmdCMEMSTimeLimits.class);

	private ServiceSupportData serviceSupportData;

	public CCmdCMEMSTimeLimits(ServiceSupportData serviceSupportData) {
		this.serviceSupportData = serviceSupportData;
		logger.debug("CCmdCMEMSTime");
	}

	@Override
	public TimeLimitsData execute() throws ServiceException {
		try {
			ClientConfig config = new ClientConfig();
			config.register(serviceSupportData.getAuthFilter());
			Client client = ClientBuilder.newClient(config);
			WebTarget service = client.target(serviceSupportData.getServiceAddress());

			// Create Request
			WebTarget serviceMin = service.path("/cmems").path("minTime");
			logger.debug("Request URI: " + serviceMin.getUri().toString());

			String minTime = serviceMin.request(MediaType.APPLICATION_XML).accept(MediaType.APPLICATION_XML).get(String.class);

			logger.debug("MinTime: "+minTime);
			
			WebTarget serviceMax = service.path("/cmems").path("maxTime");
			logger.debug("Request URI: " + serviceMax.getUri().toString());

			String maxTime = serviceMax.request(MediaType.APPLICATION_XML).accept(MediaType.APPLICATION_XML).get(String.class);

			logger.debug("MaxTime: "+maxTime);
			
			TimeLimitsData timeData=new TimeLimitsData(minTime, maxTime);
			return timeData;
			
			
		} catch (Throwable e) {
			logger.error("Error in CCmdCMEMSTime(): " + e.getLocalizedMessage(), e);
			throw new ServiceException("Error in CCmdCMEMSTime(): " + e.getLocalizedMessage(), e);

		}
	}

}
