package org.gcube.data.analysis.cmemsimportercl.server.cl.command.products;

import java.util.ArrayList;
import java.util.List;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.gcube.data.analysis.cmemsimportercl.server.cl.command.CCmd;
import org.gcube.data.analysis.cmemsimportercl.server.util.ServiceSupportData;
import org.gcube.data.analysis.cmemsimportercl.shared.data.products.KeywordData;
import org.gcube.data.analysis.cmemsimportercl.shared.exception.ServiceException;
import org.gcube.dataanalysis.copernicus.cmems.model.CmemsKeyword;
import org.glassfish.jersey.client.ClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 
 * @author Giancarlo Panichi
 *
 *
 */
public class CCmdCMEMSKeywords implements CCmd<ArrayList<KeywordData>> {
	private static final Logger logger = LoggerFactory.getLogger(CCmdCMEMSKeywords.class);

	private ServiceSupportData serviceSupportData;

	public CCmdCMEMSKeywords(ServiceSupportData serviceSupportData) {
		this.serviceSupportData = serviceSupportData;
		logger.debug("CCmdCMEMSKeywords");
	}

	@Override
	public ArrayList<KeywordData> execute() throws ServiceException {
		try {
			ClientConfig config = new ClientConfig();
			config.register(serviceSupportData.getAuthFilter());
			Client client = ClientBuilder.newClient(config);
			WebTarget service = client.target(serviceSupportData.getServiceAddress());

			// Create Request
			service=service.path("/cmems").path("keywords");
			logger.debug("Request URI: "+service.getUri().toString());
			
			Response response = service.request(MediaType.APPLICATION_XML)
					.accept(MediaType.APPLICATION_XML).get();
			
			logger.debug("Response: [" + response + "]");
			
			List<CmemsKeyword> keywords = response.readEntity(new GenericType<List<CmemsKeyword>>() {
			});

			ArrayList<KeywordData> keywordsDataList = new ArrayList<>();

			if (keywords != null && !keywords.isEmpty()) {

				for (CmemsKeyword k : keywords) {

					logger.debug("Key: "+k);
					KeywordData keywordData = new KeywordData(k.getName());

					keywordsDataList.add(keywordData);
				}

			}

			return keywordsDataList;

		} catch (Throwable e) {
			logger.error("Error in CCmdCMEMSKeywords(): " + e.getLocalizedMessage(), e);
			throw new ServiceException("Error in CCmdCMEMSKeywords(): " + e.getLocalizedMessage(), e);

		}
	}

}
