package org.gcube.data.analysis.cmemsimportercl.server.cl.command.products;

import java.util.ArrayList;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.gcube.data.analysis.cmemsimportercl.server.cl.command.CCmd;
import org.gcube.data.analysis.cmemsimportercl.server.util.ServiceSupportData;
import org.gcube.data.analysis.cmemsimportercl.shared.data.products.AxisData;
import org.gcube.data.analysis.cmemsimportercl.shared.data.products.DatasetInfoData;
import org.gcube.data.analysis.cmemsimportercl.shared.data.products.DatasetType;
import org.gcube.data.analysis.cmemsimportercl.shared.data.products.TimeCoverageData;
import org.gcube.data.analysis.cmemsimportercl.shared.data.products.VariableInfoData;
import org.gcube.data.analysis.cmemsimportercl.shared.exception.ServiceException;
import org.gcube.dataanalysis.copernicus.motu.model.Axis;
import org.gcube.dataanalysis.copernicus.motu.model.ProductMetadataInfo;
import org.gcube.dataanalysis.copernicus.motu.model.Variable;
import org.glassfish.jersey.client.ClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 
 * @author Giancarlo Panichi
 *
 *
 */
public class CCmdCMEMSDatasetInfo implements CCmd<DatasetInfoData> {
	private static final Logger logger = LoggerFactory.getLogger(CCmdCMEMSDatasetInfo.class);

	private ServiceSupportData serviceSupportData;
	private String productId;
	private DatasetType datasetType;
	private String datasetId;

	public CCmdCMEMSDatasetInfo(ServiceSupportData serviceSupportData, String productId, DatasetType datasetType,
			String datasetId) {
		this.serviceSupportData = serviceSupportData;
		this.productId = productId;
		this.datasetType = datasetType;
		this.datasetId = datasetId;

		logger.debug("CCmdCMEMSDatasetInfo: [product=" + productId + ", datasetType=" + datasetType + ", dataset="
				+ datasetId);
	}

	@Override
	public DatasetInfoData execute() throws ServiceException {
		try {
			if (productId == null || productId.isEmpty()) {
				logger.error("Error in CCmdCMEMSDatasetInfo(), invalid product: " + productId);
				throw new ServiceException("Error in CCmdCMEMSDatasetInfo(), invalid product: " + productId);

			}

			if (datasetType == null) {
				logger.error("Error in CCmdCMEMSDatasetInfo(), invalid dataset type: " + datasetType);
				throw new ServiceException("Error in CCmdCMEMSDatasetInfo(), invalid dataset type: " + datasetType);

			}

			if (datasetId == null || datasetId.isEmpty()) {
				logger.error("Error in CCmdCMEMSDatasetInfo(), invalid dataset: " + datasetId);
				throw new ServiceException("Error in CCmdCMEMSDatasetInfo(), invalid dataset: " + datasetId);

			}

			ClientConfig config = new ClientConfig();
			config.register(serviceSupportData.getAuthFilter());
			Client client = ClientBuilder.newClient(config);
			WebTarget service = client.target(serviceSupportData.getServiceAddress());

			// Create Request
			service = service.path("/cmems").path("products").path(productId).path("datasets")
					.path(datasetType.getLabel()).path(datasetId);
			logger.debug("Request URI: " + service.getUri().toString());

			Response response = service.request().accept(MediaType.APPLICATION_XML).get();

			logger.debug("Response: [" + response + "]");

			ProductMetadataInfo d = response.readEntity(ProductMetadataInfo.class);

			DatasetInfoData datasetInfoData = null;

			if (d != null) {
				logger.debug("ProductMetadataInfo: [" + d.getId() + " - " + d.getTitle() + " - " + d.getUrl() + "- "
						+ d.getMsg() + "]");

				TimeCoverageData timeCoverageData = null;
				if (d.getTimeCoverage() != null) {
					timeCoverageData = new TimeCoverageData(d.getTimeCoverage().getCode(), d.getTimeCoverage().getMsg(),
							d.getTimeCoverage().getStart(), d.getTimeCoverage().getEnd());
				}

				ArrayList<VariableInfoData> variableDataList = new ArrayList<>();
				if (d.getVariables() != null) {
					for (Variable v : d.getVariables()) {

						VariableInfoData variableData = new VariableInfoData(v.getName(), v.getCode(), v.getLongName(),
								v.getStandardName(), v.getUnits(), v.getDescription(), v.getMsg());
						variableDataList.add(variableData);
					}
				}

				ArrayList<AxisData> axisDataList = new ArrayList<>();
				if (d.getDataGeospatialCoverage() != null) {
					for (Axis a : d.getDataGeospatialCoverage()) {
						AxisData axisData = new AxisData(a.getCode(), a.getMsg(), a.getDescription(), a.getUnits(),
								a.getName(), a.getUpper(), a.getLower(), a.getAxisType());
						axisDataList.add(axisData);
					}
				}

				datasetInfoData = new DatasetInfoData(d.getCode(), d.getMsg(), d.getLastUpdate(), d.getUrl(),
						d.getTitle(), d.getId(), d.getRawAvailableTimeCodes(), d.getRawAvailableDepths(),
						timeCoverageData, variableDataList, axisDataList);

			}

			return datasetInfoData;

		} catch (

		Throwable e) {
			logger.error("Error in CCmdCMEMSDatasetInfo(): " + e.getLocalizedMessage(), e);
			throw new ServiceException("Error in CCmdCMEMSDatasetInfo(): " + e.getLocalizedMessage(), e);

		}
	}

}
