package org.gcube.data.analysis.cmemsimportercl.server.cl.command.tasks;

import java.util.ArrayList;
import java.util.Calendar;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.gcube.data.analysis.cmemsimportercl.server.cl.command.CCmd;
import org.gcube.data.analysis.cmemsimportercl.server.util.ServiceSupportData;
import org.gcube.data.analysis.cmemsimportercl.server.util.TimeUtils;
import org.gcube.data.analysis.cmemsimportercl.shared.data.tasks.ExecutionData;
import org.gcube.data.analysis.cmemsimportercl.shared.data.tasks.ExecutionReportData;
import org.gcube.data.analysis.cmemsimportercl.shared.exception.ServiceException;
import org.gcube.dataanalysis.copernicus.cmems.importer.task.Execution;
import org.gcube.dataanalysis.copernicus.cmems.importer.task.ExecutionReport;
import org.glassfish.jersey.client.ClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 
 * @author Giancarlo Panichi
 *
 *
 */
public class CCmdCMEMSExecuteTask implements CCmd<ExecutionData> {
	private static final Logger logger = LoggerFactory.getLogger(CCmdCMEMSExecuteTask.class);

	private ServiceSupportData serviceSupportData;
	private String taskId;

	public CCmdCMEMSExecuteTask(ServiceSupportData serviceSupportData, String taskId) {
		this.serviceSupportData = serviceSupportData;
		this.taskId = taskId;
		logger.debug("CCmdCMEMSExecuteTask");
		logger.debug("TaskId: " + taskId);
	}

	@Override
	public ExecutionData execute() throws ServiceException {
		try {
			if (taskId == null || taskId.isEmpty()) {
				logger.error("Error in CCmdCMEMSExecuteTask(), invalid task id: " + taskId);
				throw new ServiceException("Error in CCmdCMEMSExecuteTask(), invalid task id: " + taskId);
			}

			ClientConfig config = new ClientConfig();
			config.register(serviceSupportData.getAuthFilter());
			Client client = ClientBuilder.newClient(config);
			WebTarget service = client.target(serviceSupportData.getServiceAddress());

			service = service.path("tasks").path(taskId).path("executions");
			logger.debug("Request URI: " + service.getUri().toString());

			Entity<String> data = Entity.entity(taskId, MediaType.APPLICATION_XML);

			Response response = service.request(MediaType.APPLICATION_XML).accept(MediaType.APPLICATION_XML).post(data);

			logger.debug("Response: [" + response + "]");

			Execution execution = response.readEntity(Execution.class);

			logger.debug("Execute Task: [" + execution + "]");

			ExecutionData executionData = null;

			if (execution != null) {
				logger.debug("Execution: [" + execution.getId() + "]");

				executionData = new ExecutionData();

				String timeBegin = null;
				try {
					Calendar calendarBegin = execution.getBegin();
					if (calendarBegin != null) {
						timeBegin = TimeUtils.toString(execution.getBegin());
					}
				} catch (Throwable e) {
					logger.error(e.getLocalizedMessage(), e);
				}

				String timeEnd = null;
				try {
					Calendar calendarEnd = execution.getEnd();
					if (calendarEnd != null) {
						timeEnd = TimeUtils.toString(execution.getEnd());
					}
				} catch (Throwable e) {
					logger.error(e.getLocalizedMessage(), e);
				}

				String timeLast = null;
				try {
					Calendar calendarLast = execution.getLastUpdate();
					if (calendarLast != null) {
						timeLast = TimeUtils.toString(execution.getLastUpdate());
					}
				} catch (Throwable e) {
					logger.error(e.getLocalizedMessage(), e);
				}

				executionData.setId(execution.getId());
				executionData.setBegin(timeBegin);
				executionData.setEnd(timeEnd);
				executionData.setLastUpdate(timeLast);
				executionData.setStatus(execution.getStatus().value());
				executionData.setProgress(execution.getProgress());

				ArrayList<ExecutionReportData> reports = new ArrayList<>();

				if (execution.getReports() != null && !execution.getReports().isEmpty()) {

					for (ExecutionReport r : execution.getReports()) {
						ExecutionReportData report = new ExecutionReportData(r.getName(), r.getText(), r.getSnippet(),
								r.getSize());
						reports.add(report);
					}
				}
				executionData.setReports(reports);

			}
			return executionData;

		} catch (Throwable e) {
			logger.error("Error in CCmdCMEMSExecuteTask(): " + e.getLocalizedMessage(), e);
			throw new ServiceException("Error in CCmdCMEMSExecuteTask(): " + e.getLocalizedMessage(), e);

		}
	}

}
